/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.handler;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentLocalEditHandler
extends AbstractHandler
implements IHandler {
    private static Logger logger = LoggerFactory.getLogger(DocumentLocalEditHandler.class);
    private static final String LOCAL_EDIT_START = "ch.elexis.core.ui.documents.commandLocalEditStart";
    private static final String LOCAL_EDIT_ABORT = "ch.elexis.core.ui.documents.commandLocalEditAbort";
    private static final String LOCAL_EDIT_DONE = "ch.elexis.core.ui.documents.commandLocalEditDone";
    private static final String LOCAL_EDIT_OVERVIEW = "ch.elexis.core.ui.documents.commandLocalEditOverview";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block15: {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (!(selection instanceof StructuredSelection) || ((StructuredSelection)selection).isEmpty()) break block15;
            List iDocuments = ((StructuredSelection)selection).toList();
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            for (Object document : iDocuments) {
                if (!(document instanceof IDocument)) continue;
                switch (event.getCommand().getId()) {
                    case "ch.elexis.core.ui.documents.commandLocalEditStart": {
                        this.sendLocalEditEvent((IDocument)document, commandService.getCommand("ch.elexis.core.ui.command.startEditLocalDocument"));
                        break;
                    }
                    case "ch.elexis.core.ui.documents.commandLocalEditAbort": {
                        this.sendLocalEditEvent((IDocument)document, commandService.getCommand("ch.elexis.core.ui.command.abortLocalDocument"));
                        break;
                    }
                    case "ch.elexis.core.ui.documents.commandLocalEditDone": {
                        this.sendLocalEditEvent((IDocument)document, commandService.getCommand("ch.elexis.core.ui.command.endLocalDocument"));
                        break;
                    }
                }
                this.sendReloadViewEvent(document);
            }
        }
        if (LOCAL_EDIT_OVERVIEW.equals(event.getCommand().getId())) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            this.createEvent(commandService.getCommand("ch.elexis.core.ui.command.openLocalDocuments"), null);
            this.sendReloadViewEvent(null);
        }
        return null;
    }

    private void sendReloadViewEvent(Object document) {
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(document, IDocument.class, 8, 10000)});
    }

    private void sendLocalEditEvent(IDocument document, Command command) {
        DocumentStoreServiceHolder.getService().getPersistenceObject(document).ifPresent(po -> this.createEvent(command, (Identifiable)po));
    }

    private void createEvent(Command command, Identifiable po) {
        StructuredSelection iStructuredSelection = null;
        if (po != null) {
            iStructuredSelection = new StructuredSelection((Object)po);
        }
        ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)iStructuredSelection);
        try {
            command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            logger.error("cannot executre local edit event", e);
        }
    }
}

