/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.dialogs;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.ui.documents.views.DocumentsTreeContentProvider;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class DocumentsSelectionDialog
extends CheckedTreeSelectionDialog {
    private LastSevenViewerFilter lastSevenFilter;

    public DocumentsSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, int style) {
        super(parent, labelProvider, contentProvider, style);
        this.setStatusLineAboveButtons(false);
        this.lastSevenFilter = new LastSevenViewerFilter();
    }

    public void create() {
        super.create();
        if (this.getTreeViewer().getContentProvider() instanceof DocumentsTreeContentProvider) {
            ((DocumentsTreeContentProvider)this.getTreeViewer().getContentProvider()).setViewer((TreeViewer)this.getTreeViewer());
        }
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(4, 128, true, false);
        buttonComposite.setLayoutData((Object)data);
        final Button lastSevenButton = new Button(buttonComposite, 2);
        lastSevenButton.setText("Dokumente der letzten 7 Tage");
        lastSevenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (lastSevenButton.getSelection()) {
                    DocumentsSelectionDialog.this.getTreeViewer().addFilter((ViewerFilter)DocumentsSelectionDialog.this.lastSevenFilter);
                    DocumentsSelectionDialog.this.getTreeViewer().expandAll();
                } else {
                    DocumentsSelectionDialog.this.getTreeViewer().removeFilter((ViewerFilter)DocumentsSelectionDialog.this.lastSevenFilter);
                    DocumentsSelectionDialog.this.getTreeViewer().refresh();
                }
            }
        });
        return buttonComposite;
    }

    private class LastSevenViewerFilter
    extends ViewerFilter {
        private LastSevenViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IDocument) {
                IDocument document = (IDocument)element;
                LocalDate lastChange = LocalDateTime.ofInstant(document.getLastchanged().toInstant(), ZoneId.systemDefault()).toLocalDate();
                return ChronoUnit.DAYS.between(lastChange, LocalDate.now()) < 8L;
            }
            return true;
        }
    }
}

