/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.RectVector;
import org.bytedeco.opencv.opencv_objdetect.CascadeClassifier;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceDetectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(FaceDetectionUtil.class);
    private static CascadeClassifier faceCascade;
    private static CascadeClassifier profileCascade;
    private static final String CASCADE_RESOURCE = "/rsc/cascade/haarcascade_frontalface_default.xml";
    private static final String PROFILE_CASCADE = "/rsc/cascade/haarcascade_profileface.xml";

    public static synchronized void init() {
        if (faceCascade == null) {
            faceCascade = FaceDetectionUtil.loadCascade(CASCADE_RESOURCE);
            profileCascade = FaceDetectionUtil.loadCascade(PROFILE_CASCADE);
        }
    }

    private static CascadeClassifier loadCascade(String resourcePath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = FaceDetectionUtil.class.getResourceAsStream(resourcePath);){
                if (is == null) {
                    logger.error("Cascade XML not found at resource path: {}", (Object)resourcePath);
                    throw new RuntimeException("Cascade XML not found: " + resourcePath);
                }
                File tmp = File.createTempFile("cascade", ".xml");
                tmp.deleteOnExit();
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (FileOutputStream fos = new FileOutputStream(tmp);){
                    int len;
                    byte[] buf = new byte[4096];
                    while ((len = is.read(buf)) > 0) {
                        fos.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                return new CascadeClassifier(tmp.getAbsolutePath());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            logger.error("Error loading cascade XML '{}': {}", new Object[]{resourcePath, ex.getMessage(), ex});
            throw new RuntimeException("Error loading cascade XML: " + resourcePath, ex);
        }
    }

    public static Rectangle detectFace(BufferedImage img) {
        Mat mat;
        FaceDetectionUtil.init();
        try {
            mat = FaceDetectionUtil.bufferedImageToMat(img);
        }
        catch (Exception e) {
            logger.error("Error converting BufferedImage to Mat: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        Mat gray = new Mat();
        opencv_imgproc.cvtColor((Mat)mat, (Mat)gray, (int)6);
        opencv_imgproc.equalizeHist((Mat)gray, (Mat)gray);
        RectVector fr = new RectVector();
        faceCascade.detectMultiScale(gray, fr);
        Rectangle r = FaceDetectionUtil.pickLargest(fr);
        if (r != null) {
            return r;
        }
        RectVector pr = new RectVector();
        profileCascade.detectMultiScale(gray, pr);
        r = FaceDetectionUtil.pickLargest(pr);
        if (r != null) {
            return r;
        }
        Mat flipped = new Mat();
        opencv_core.flip((Mat)gray, (Mat)flipped, (int)1);
        RectVector prF = new RectVector();
        profileCascade.detectMultiScale(flipped, prF);
        Rectangle best = null;
        long maxA = 0L;
        int i = 0;
        while ((long)i < prF.size()) {
            Rect rr = prF.get((long)i);
            long area = (long)rr.width() * (long)rr.height();
            if (area > maxA) {
                int x = gray.cols() - rr.x() - rr.width();
                best = new Rectangle(x, rr.y(), rr.width(), rr.height());
                maxA = area;
            }
            ++i;
        }
        if (best == null) {
            logger.info("No face detected in image.");
        }
        return best;
    }

    private static Rectangle pickLargest(RectVector vec) {
        Rect best = null;
        long maxArea = 0L;
        int i = 0;
        while ((long)i < vec.size()) {
            Rect r = vec.get((long)i);
            long area = (long)r.width() * (long)r.height();
            if (area > maxArea) {
                maxArea = area;
                best = r;
            }
            ++i;
        }
        if (best != null) {
            return new Rectangle(best.x(), best.y(), best.width(), best.height());
        }
        return null;
    }

    private static Mat bufferedImageToMat(BufferedImage bi) {
        BufferedImage converted = bi;
        if (bi.getType() != 5) {
            BufferedImage tmp = new BufferedImage(bi.getWidth(), bi.getHeight(), 5);
            tmp.getGraphics().drawImage(bi, 0, 0, null);
            converted = tmp;
        }
        byte[] pixels = ((DataBufferByte)converted.getRaster().getDataBuffer()).getData();
        Mat mat = new Mat(converted.getHeight(), converted.getWidth(), opencv_core.CV_8UC3);
        mat.data().put(pixels);
        return mat;
    }
}

