/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TaskTriggerType implements Enumerator
{
    MANUAL(0, "MANUAL", "MANUAL"),
    FILESYSTEM_CHANGE(1, "FILESYSTEM_CHANGE", "FILESYSTEM_CHANGE"),
    CRON(2, "CRON", "CRON"),
    SYSTEM_EVENT(3, "SYSTEM_EVENT", "SYSTEM_EVENT"),
    OTHER_TASK(4, "OTHER_TASK", "OTHER_TASK");

    public static final int MANUAL_VALUE = 0;
    public static final int FILESYSTEM_CHANGE_VALUE = 1;
    public static final int CRON_VALUE = 2;
    public static final int SYSTEM_EVENT_VALUE = 3;
    public static final int OTHER_TASK_VALUE = 4;
    private static final TaskTriggerType[] VALUES_ARRAY;
    public static final List<TaskTriggerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TaskTriggerType[]{MANUAL, FILESYSTEM_CHANGE, CRON, SYSTEM_EVENT, OTHER_TASK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TaskTriggerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TaskTriggerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TaskTriggerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TaskTriggerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TaskTriggerType get(int value) {
        switch (value) {
            case 0: {
                return MANUAL;
            }
            case 1: {
                return FILESYSTEM_CHANGE;
            }
            case 2: {
                return CRON;
            }
            case 3: {
                return SYSTEM_EVENT;
            }
            case 4: {
                return OTHER_TASK;
            }
        }
        return null;
    }

    private TaskTriggerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

