/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service.quartz;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.internal.service.quartz.TriggerTaskJob;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzExecutor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SchedulerFactory sf;
    private Scheduler sched;
    private final SimpleDateFormat FULL_ISO = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public QuartzExecutor() {
        this.sf = new StdSchedulerFactory();
        try {
            this.sched = this.sf.getScheduler();
        }
        catch (SchedulerException e) {
            this.logger.error("Error getting scheduler", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void incur(ITaskService taskService, ITaskDescriptor taskDescriptor) throws TaskException {
        taskService.instantiateRunnableById(taskDescriptor.getIdentifiedRunnableId());
        String cron = taskDescriptor.getTriggerParameters().get("cron");
        CronScheduleBuilder cronSchedule = CronScheduleBuilder.cronSchedule((String)cron);
        JobKey jobKey = new JobKey(taskDescriptor.getId());
        JobDataMap jobDataMap = new JobDataMap(taskDescriptor.getRunContext());
        jobDataMap.put("taskDescriptor", (Object)taskDescriptor);
        jobDataMap.put("taskService", (Object)taskService);
        JobDetail jobDetail = JobBuilder.newJob(TriggerTaskJob.class).withIdentity(jobKey).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(taskDescriptor.getId()).withSchedule((ScheduleBuilder)cronSchedule).usingJobData(jobDataMap).build();
        try {
            this.sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            this.logger.warn("#incur - " + taskDescriptor.getId(), (Throwable)e);
        }
    }

    public void release(ITaskDescriptor taskDescriptor) throws TaskException {
        JobKey jobKey = new JobKey(taskDescriptor.getId());
        try {
            if (this.sched.isShutdown()) {
                return;
            }
            boolean exists = this.sched.checkExists(jobKey);
            if (exists) {
                this.sched.deleteJob(jobKey);
            } else {
                this.logger.info("#release - job does not exist [" + String.valueOf(jobKey) + "]");
            }
        }
        catch (SchedulerException e) {
            throw new TaskException(7, (Throwable)e);
        }
    }

    public void shutdown() throws SchedulerException {
        if (this.sched != null) {
            this.sched.shutdown();
        }
    }

    public void start() throws SchedulerException {
        this.sched.start();
    }

    public Set<String[]> getIncurred() {
        HashSet<String[]> incurred = new HashSet<String[]>();
        try {
            Set jobKeys = this.sched.getJobKeys(GroupMatcher.anyGroup());
            for (JobKey jobKey : jobKeys) {
                String taskDescriptorId = jobKey.getName();
                if (!this.sched.checkExists(jobKey)) continue;
                Trigger trigger = this.sched.getTrigger(TriggerKey.triggerKey((String)taskDescriptorId));
                Date nextFireTime = trigger.getNextFireTime();
                incurred.add(new String[]{taskDescriptorId, this.FULL_ISO.format(nextFireTime)});
            }
        }
        catch (SchedulerException e) {
            this.logger.warn("#getIncurredTasks", (Throwable)e);
        }
        return incurred;
    }
}

