/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.internal;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.pdfbox.ui.parts.PdfPreviewPartLoadHandler;
import ch.elexis.core.pdfbox.ui.parts.handlers.PDFTextHighlighter;
import ch.elexis.core.spotlight.ISpotlightService;
import ch.elexis.core.spotlight.ui.controls.SpotlightResultComposite;
import ch.elexis.core.spotlight.ui.controls.SpotlightSearchHelper;
import ch.elexis.core.spotlight.ui.internal.ISpotlightResultEntryDetailCompositeService;
import ch.elexis.core.spotlight.ui.internal.SpotlightUiUtil;
import ch.elexis.core.spotlight.ui.internal.ready.SpotlightReadyComposite;
import ch.elexis.core.spotlight.ui.internal.ready.SpotlightReadyService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SpotlightShell
extends Shell {
    private static boolean ispdfPreviewComp = false;
    private EPartService partService;
    private ISpotlightService spotlightService;
    private ISpotlightResultEntryDetailCompositeService resultEntryDetailCompositeService;
    private SpotlightReadyService spotlightReadyService;
    private Map<String, String> spotlightContextParameters;
    private Timer timer;
    private Text txtSearchInput;
    private Composite filterComposite;
    private Composite layeredComposite;
    private SpotlightResultComposite resultComposite;
    private SpotlightReadyComposite readyComposite;
    private StackLayout detailCompositeStackLayout;
    private SpotlightUiUtil uiUtil;
    private String searchText;
    private Object selectedElement;
    private Composite previewComposite;
    private GridData layeredCompositeGridData;
    private Point origin;
    private PdfPreviewPartLoadHandler pdfPreviewPartLoadHandler;
    private ScrolledComposite scrolledComposite;
    private Label lblFound;
    private final String SEARCH_ICON = "spotlight-search-icon";
    private final String SEARCHTEXT_FONT = "spotlight-searchtext-font";
    private int lableText;
    private Composite parentComposite;
    private InputStream pdfIDocument;

    public SpotlightShell(Shell shell, EPartService partService, ISpotlightService spotlightService, ISpotlightResultEntryDetailCompositeService resultEntryDetailCompositeService, SpotlightReadyService spotlightReadyService, Map<String, String> spotlightContextParameters) {
        super(shell, 2060);
        this.partService = partService;
        this.spotlightService = spotlightService;
        this.resultEntryDetailCompositeService = resultEntryDetailCompositeService;
        this.spotlightReadyService = spotlightReadyService;
        this.spotlightContextParameters = spotlightContextParameters;
        this.addListener(31, event -> {
            switch (event.detail) {
                case 2: {
                    this.close();
                    event.detail = 0;
                    event.doit = false;
                    break;
                }
                case 4: {
                    boolean ok = this.handleSelectedElement();
                    if (ok && !this.isDisposed()) {
                        this.close();
                    }
                    event.detail = 0;
                    event.doit = true;
                }
            }
        });
        this.addListener(27, event -> this.close());
        this.uiUtil = new SpotlightUiUtil(partService);
        CoreUiUtil.injectServicesWithContext((Object)this.uiUtil);
        this.setSize(800, 500);
        this.createContents();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SpotlightShell.this.origin = new Point(e.x, e.y);
            }

            public void mouseUp(MouseEvent e) {
                SpotlightShell.this.origin = null;
            }
        });
        this.addMouseMoveListener(e -> {
            if (this.origin != null) {
                Point p = this.toDisplay(e.x, e.y);
                this.setLocation(p.x - this.origin.x, p.y - this.origin.y);
            }
        });
    }

    protected void createContents() {
        Font biggerFont;
        GridLayout gridLayout = new GridLayout(3, false);
        this.setLayout((Layout)gridLayout);
        this.addListener(22, event -> this.adjustShellSize(false));
        this.filterComposite = new Composite((Composite)this, 524288);
        this.filterComposite.setLayout((Layout)new GridLayout(1, false));
        this.filterComposite.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.filterComposite.setBackground(this.getBackground());
        if (this.spotlightContextParameters != null && this.spotlightContextParameters.containsKey("patientId")) {
            Label patientFilter = new Label(this.filterComposite, 0);
            patientFilter.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            patientFilter.setImage(Images.IMG_PERSON.getImage());
            patientFilter.setBackground(this.getDisplay().getSystemColor(15));
            patientFilter.setLayoutData((Object)new GridData(16384, 4, false, false));
        }
        Composite searchComposite = new Composite((Composite)this, 0);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblIcon = new Label(searchComposite, 0);
        lblIcon.setImage(this.getImage("spotlight-search-icon", "rsc/icons/magnifier-left-24.png"));
        lblIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtSearchInput = new Text(searchComposite, 0);
        GridData txtSearchInputGridData = new GridData(4, 0x1000000, true, false);
        this.txtSearchInput.setLayoutData((Object)txtSearchInputGridData);
        this.txtSearchInput.setBackground(this.getBackground());
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 4;
        buttonGridData.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)buttonGridData);
        GridData gridData = new GridData(0x1000008, 16384, false, false);
        gridData.widthHint = 55;
        gridData.heightHint = 20;
        this.lblFound = new Label(buttonComposite, 0x1020000);
        this.lblFound.setText("Gefundene Suchw\u00f6rter:     00 / 00  ");
        this.lblFound.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button upButton = new Button(buttonComposite, 0x800008);
        upButton.setImage(Images.IMG_PREVIOUS.getImage());
        upButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        upButton.setLayoutData((Object)gridData);
        Button downButton = new Button(buttonComposite, 0x800008);
        downButton.setImage(Images.IMG_NEXT.getImage());
        downButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        downButton.setLayoutData((Object)gridData);
        this.txtSearchInput.setToolTipText(Messages.SpotlightSerchHelText);
        if (JFaceResources.getFontRegistry().hasValueFor("spotlight-searchtext-font")) {
            biggerFont = JFaceResources.getFontRegistry().get("spotlight-searchtext-font");
        } else {
            FontData[] fontData = this.txtSearchInput.getFont().getFontData();
            fontData[0].setHeight(20);
            JFaceResources.getFontRegistry().put("spotlight-searchtext-font", fontData);
            biggerFont = JFaceResources.getFontRegistry().get("spotlight-searchtext-font");
        }
        this.txtSearchInput.setFont(biggerFont);
        this.txtSearchInput.setMessage("Suchbegriff eingeben");
        this.txtSearchInput.setTextLimit(256);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpotlightSearchHelper.getNextPosition();
                SpotlightShell.this.updateLabel();
                try {
                    PDFTextHighlighter.getNextMatch();
                    if (SpotlightShell.this.pdfPreviewPartLoadHandler != null) {
                        SpotlightShell.this.pdfPreviewPartLoadHandler.reloadPdf();
                    }
                    SpotlightShell.this.updateLabel();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpotlightSearchHelper.getPreviousPosition();
                SpotlightShell.this.updateLabel();
                try {
                    PDFTextHighlighter.getPreviousMatch();
                    if (SpotlightShell.this.pdfPreviewPartLoadHandler != null) {
                        SpotlightShell.this.pdfPreviewPartLoadHandler.reloadPdf();
                    }
                    SpotlightShell.this.updateLabel();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.txtSearchInput.addModifyListener(change -> {
            String text = ((Text)change.widget).getText();
            this.setSearchText(text);
            final String searchTextForSearch = text.replace("+", " ");
            if (this.timer != null) {
                this.timer.cancel();
            }
            boolean isReadyMode = StringUtils.isEmpty((CharSequence)text);
            this.switchReadyResultMode(isReadyMode);
            this.layeredComposite.layout(true, true);
            this.adjustShellSize(false);
            this.resultComposite.clearResults();
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(() -> {
                        if (!SpotlightShell.this.isDisposed()) {
                            SpotlightShell.this.spotlightService.computeResult(searchTextForSearch, SpotlightShell.this.spotlightContextParameters);
                            SpotlightSearchHelper.clearTotalMatches();
                        }
                    });
                }
            }, 200L);
        });
        this.txtSearchInput.addListener(1, event -> {
            boolean success;
            if (event.keyCode == 13) {
                success = this.resultComposite.handleEnterOnFirstSpotlightResultEntry();
                if (success) {
                    this.close();
                }
            } else if (event.keyCode == 0x1000002) {
                this.layeredComposite.setFocus();
            }
            if (event.stateMask == 65536) {
                event.doit = false;
                success = this.resultComposite.handleAltKeyPressed(event.keyCode);
                if (success && !this.isDisposed()) {
                    this.close();
                }
            }
        });
        Label lblSeparator = new Label((Composite)this, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.parentComposite = new Composite((Composite)this, 0);
        GridLayout parentLayout = new GridLayout(2, false);
        this.parentComposite.setLayout((Layout)parentLayout);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.layeredComposite = new Composite(this.parentComposite, 0);
        this.detailCompositeStackLayout = new StackLayout();
        this.layeredComposite.setLayout((Layout)this.detailCompositeStackLayout);
        this.layeredCompositeGridData = new GridData(4, 4, true, true);
        this.layeredCompositeGridData.widthHint = 1200;
        this.layeredComposite.setLayoutData((Object)this.layeredCompositeGridData);
        this.readyComposite = new SpotlightReadyComposite(this.layeredComposite, 0, this.partService, this.spotlightReadyService);
        this.detailCompositeStackLayout.topControl = this.readyComposite;
        this.resultComposite = new SpotlightResultComposite(this.layeredComposite, 0, this.spotlightService, this.uiUtil, this.resultEntryDetailCompositeService);
        this.scrolledComposite = new ScrolledComposite(this.parentComposite, 768);
        GridData scGridData = new GridData(4, 4, true, true);
        this.scrolledComposite.setLayoutData((Object)scGridData);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.previewComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.previewComposite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(this.previewComposite, 0);
        label.setText(Messages.PdfPreview_NoPDFSelected);
        this.previewComposite.layout();
        this.scrolledComposite.setContent((Control)this.previewComposite);
        this.scrolledComposite.setMinSize(this.previewComposite.computeSize(-1, -1));
        this.setTabList(new Control[]{searchComposite, this.parentComposite});
        this.parentComposite.setTabList(new Control[]{this.layeredComposite, this.scrolledComposite});
        this.switchReadyResultMode(true);
        this.txtSearchInput.setFocus();
        this.previewComposite.setVisible(ispdfPreviewComp);
        this.adjustShellSize(true);
    }

    private void switchReadyResultMode(boolean setReadyMode) {
        if (setReadyMode) {
            this.resultComposite.setEnabled(false);
            this.readyComposite.setEnabled(true);
            this.detailCompositeStackLayout.topControl = this.readyComposite;
            this.layeredComposite.setTabList(new Control[]{this.readyComposite});
            this.resultComposite.clearResults();
        } else {
            this.resultComposite.setEnabled(true);
            this.readyComposite.setEnabled(false);
            this.detailCompositeStackLayout.topControl = this.resultComposite;
            this.layeredComposite.setTabList(new Control[]{this.resultComposite});
        }
    }

    public static boolean ispdfPreviewComposite() {
        return ispdfPreviewComp;
    }

    public boolean setFocusAppendChar(char charachter) {
        boolean result = this.txtSearchInput.setFocus();
        String text = this.txtSearchInput.getText();
        if ('\b' == charachter) {
            this.txtSearchInput.setText(text.substring(0, text.length() - 1));
        } else {
            this.txtSearchInput.setText(text + charachter);
        }
        this.txtSearchInput.setSelection(this.txtSearchInput.getText().length());
        return result;
    }

    protected void checkSubclass() {
    }

    public void setSelectedElement(Object element) {
        this.selectedElement = element;
    }

    public boolean handleSelectedElement() {
        return this.uiUtil.handleEnter(this.selectedElement);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText.trim();
    }

    public void setlableText(int count) {
        this.lableText = count;
        this.lblFound.setText("Gefundene Suchw\u00f6rter: " + count);
        Display.getCurrent().syncExec(() -> this.getParent().layout(true, true));
    }

    public int getlableText() {
        return this.lableText;
    }

    public void updatePdfPreview(InputStream pdfIDocument2) {
        this.pdfIDocument = pdfIDocument2;
        this.pdfPreviewPartLoadHandler = new PdfPreviewPartLoadHandler(pdfIDocument2, Float.valueOf("0.9f"), this.previewComposite, this.scrolledComposite);
        this.pdfPreviewPartLoadHandler.setSearchText(this.searchText);
        this.previewComposite.setVisible(ispdfPreviewComp);
    }

    public void adjustShellSize(boolean pdfViewerVisible) {
        if (pdfViewerVisible) {
            this.setSize(1300, 800);
            this.layeredCompositeGridData.widthHint = 950;
            ispdfPreviewComp = true;
        } else {
            this.setSize(800, 500);
            this.layeredCompositeGridData.widthHint = 500;
            ispdfPreviewComp = false;
        }
    }

    public void updateLabel() {
        int currentPosition = SpotlightSearchHelper.getCurrentPosition() + 1;
        int total = SpotlightSearchHelper.getTotalMatches();
        this.lblFound.setText("Gefundene Suchw\u00f6rter: " + currentPosition + " / " + total);
        Display.getCurrent().syncExec(() -> this.getParent().layout(true, true));
    }

    private Image getImage(String iconKey, String imagePath) {
        Image icon = JFaceResources.getImageRegistry().get(iconKey);
        if (icon == null) {
            Path path = new Path(imagePath);
            URL fileLocation = FileLocator.find((Bundle)FrameworkUtil.getBundle(SpotlightShell.class), (IPath)path, null);
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)fileLocation);
            JFaceResources.getImageRegistry().put(iconKey, id);
            icon = JFaceResources.getImageRegistry().get(iconKey);
        }
        return icon;
    }
}

