/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.controls.detail;

import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PatientDetailCompositeUtil {
    private DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("EE, dd.MM.yy HH:MM");
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    String getAppointmentLabel(IAppointment appointment) {
        if (appointment == null) {
            return "-";
        }
        return this.dayFormatter.format(appointment.getStartTime()) + " - " + appointment.getReason() + " bei " + appointment.getSchedule();
    }

    void clearComposite(Composite composite, Control ... exclude) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (exclude == null) {
                control.dispose();
            } else {
                boolean excluded = false;
                int i = 0;
                while (i < exclude.length) {
                    if (exclude[i].equals(control)) {
                        excluded = true;
                        break;
                    }
                    ++i;
                }
                if (!excluded) {
                    control.dispose();
                }
            }
            ++n2;
        }
        composite.layout();
    }

    public String formatDate(LocalDate date) {
        return this.dateFormatter.format(date);
    }

    String getFormattedFamilyDoctor(IPatient patient) {
        IContact familyDoctor;
        if (patient != null && (familyDoctor = patient.getFamilyDoctor()) != null) {
            String label = familyDoctor.getDescription1() + ", " + familyDoctor.getDescription2();
            if (StringUtils.isNotEmpty((CharSequence)familyDoctor.getCode())) {
                label = label + " (" + familyDoctor.getCode() + ")";
            }
            return label;
        }
        return "-";
    }

    String getFormattedInsurance(IModelService coreModelService, IPatient patient) {
        if (patient != null) {
            IContact guarantor;
            IQuery firstKvgQuery = coreModelService.getQuery(ICoverage.class);
            firstKvgQuery.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
            firstKvgQuery.and("gesetz", IQuery.COMPARATOR.EQUALS, (Object)"KVG");
            firstKvgQuery.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.DESC);
            firstKvgQuery.limit(1);
            ICoverage firstKvg = firstKvgQuery.executeSingleResult().orElse(null);
            IContact iContact = guarantor = firstKvg != null ? firstKvg.getGuarantor() : null;
            if (guarantor != null) {
                return guarantor.getLabel();
            }
        }
        return "-";
    }

    String getFormattedPatientBalance(IModelService coreModelService, IPatient patient) {
        if (patient != null) {
            List balanceResult = Collections.emptyList();
            INamedQuery namedQuery = coreModelService.getNamedQuery(Number.class, IAccountTransaction.class, true, new String[]{"balance.patient"});
            balanceResult = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"patient", patient}));
            if (!balanceResult.isEmpty()) {
                int _balance = ((Number)balanceResult.get(0)).intValue();
                return "CHF " + String.valueOf(new Money(_balance));
            }
        }
        return "-";
    }

    String getFormattedFixedMedication(IModelService coreModelService, IPatient patient) {
        List fixedMedication;
        if (patient != null && !(fixedMedication = patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION))).isEmpty()) {
            return fixedMedication.stream().map(m -> m.getLabel()).reduce((u, t) -> u + "\r\n" + t).get();
        }
        return "-";
    }

    IAppointment getNextAppointment(IModelService coreModelService, IPatient patient) {
        if (patient != null) {
            IQuery futureAppointmentsQuery = coreModelService.getQuery(IAppointment.class);
            futureAppointmentsQuery.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SUBJECT_OR_PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient.getId());
            futureAppointmentsQuery.and("tag", IQuery.COMPARATOR.GREATER, (Object)LocalDate.now());
            futureAppointmentsQuery.orderBy("tag", IQuery.ORDER.ASC);
            futureAppointmentsQuery.limit(1);
            return futureAppointmentsQuery.executeSingleResult().orElse(null);
        }
        return null;
    }

    IAppointment getPreviousAppointment(IModelService coreModelService, IPatient patient) {
        if (patient != null) {
            IQuery lastAppointmentQuery = coreModelService.getQuery(IAppointment.class);
            lastAppointmentQuery.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SUBJECT_OR_PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient.getId());
            lastAppointmentQuery.and("tag", IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            lastAppointmentQuery.orderBy("tag", IQuery.ORDER.DESC);
            lastAppointmentQuery.limit(1);
            return lastAppointmentQuery.executeSingleResult().orElse(null);
        }
        return null;
    }

    String getFormattedLatestLaboratoryDate(IModelService coreModelService, IPatient patient) {
        if (patient != null) {
            IQuery labResultQuery = coreModelService.getQuery(ILabResult.class);
            labResultQuery.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
            labResultQuery.orderBy((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__DATE, IQuery.ORDER.DESC);
            labResultQuery.limit(1);
            ILabResult latestResult = labResultQuery.executeSingleResult().orElse(null);
            if (latestResult != null) {
                return this.formatDate(latestResult.getDate());
            }
        }
        return "-";
    }
}

