/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class SpotlightSearchHelper {
    private static final List<MatchPosition> foundPositions = new ArrayList<MatchPosition>();
    private static int currentPosition = -1;
    private static StyledText styledText;

    public static int highlightSearchText(StyledText styledText2, String searchText) {
        currentPosition = 0;
        styledText = styledText2;
        foundPositions.clear();
        String fullText = styledText.getText().toLowerCase();
        styledText.setStyleRange(null);
        int highlightCount = 0;
        int plusIndex = searchText.indexOf(43);
        if (plusIndex != -1) {
            String beforePlus = searchText.substring(0, plusIndex).toLowerCase();
            String afterPlus = searchText.substring(plusIndex + 1).toLowerCase();
            if (!beforePlus.isEmpty()) {
                String[] wordsBeforePlus = beforePlus.split("\\s+");
                String lastWordBeforePlus = wordsBeforePlus[wordsBeforePlus.length - 1];
                String exakt = lastWordBeforePlus + "+" + afterPlus;
                SpotlightSearchHelper.highlightExactPhrase(styledText, exakt.replace("+", " "), fullText);
            }
        } else {
            String[] searchWords;
            String[] stringArray = searchWords = searchText.toLowerCase().split("\\s+");
            int n = searchWords.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (!word.isEmpty()) {
                    highlightCount += SpotlightSearchHelper.highlightWord(styledText, word, fullText);
                }
                ++n2;
            }
        }
        return highlightCount;
    }

    private static void highlightExactPhrase(StyledText styledText, String phrase, String fullText) {
        String searchRegex = SpotlightSearchHelper.escapeRegexSpecialCharacters(phrase);
        Pattern pattern = Pattern.compile(searchRegex);
        Matcher matcher = pattern.matcher(fullText);
        if (matcher.find()) {
            int index = matcher.start();
            foundPositions.add(new MatchPosition(matcher.start(), matcher.end() - matcher.start()));
            StyleRange styleRange = new StyleRange();
            styleRange.start = index;
            styleRange.length = matcher.end() - index;
            styleRange.background = Display.getCurrent().getSystemColor(7);
            styledText.setStyleRange(styleRange);
            SpotlightSearchHelper.centerTextAtPosition(styledText, index);
        }
    }

    private static int highlightWord(StyledText styledText, String word, String fullText) {
        String searchRegex = SpotlightSearchHelper.escapeRegexSpecialCharacters(word);
        Pattern pattern = Pattern.compile(searchRegex);
        Matcher matcher = pattern.matcher(fullText);
        int wordCount = 0;
        boolean isFirstMatch = true;
        while (matcher.find()) {
            ++wordCount;
            int index = matcher.start();
            foundPositions.add(new MatchPosition(matcher.start(), matcher.end() - matcher.start()));
            StyleRange styleRange = new StyleRange();
            styleRange.start = index;
            styleRange.length = matcher.end() - index;
            styleRange.background = Display.getCurrent().getSystemColor(7);
            styledText.setStyleRange(styleRange);
            if (!isFirstMatch) continue;
            SpotlightSearchHelper.centerTextAtPosition(styledText, index);
            isFirstMatch = false;
        }
        return wordCount;
    }

    private static String escapeRegexSpecialCharacters(String word) {
        String escapedWord = word.replaceAll("([\\\\\\[\\](){}.*+?^$|])", "\\\\$1").replace("ue", "(\u00fc|ue)").replace("oe", "(\u00f6|oe)").replace("ae", "(\u00e4|ae)").replace("ss", "(\u00df|ss)");
        return escapedWord;
    }

    public static void centerTextAtPosition(StyledText styledText, int position) {
        Display.getDefault().asyncExec(() -> {
            if (!styledText.isDisposed()) {
                int line = styledText.getLineAtOffset(position);
                int linesVisible = styledText.getClientArea().height / styledText.getLineHeight();
                int topLine = line - linesVisible / 6;
                styledText.setTopIndex(Math.max(topLine, 0));
                styledText.redraw();
            }
        });
    }

    public static MatchPosition getNextPosition() {
        if (currentPosition >= foundPositions.size() - 1) {
            return null;
        }
        SpotlightSearchHelper.highlightCurrentPosition(styledText);
        return foundPositions.get(++currentPosition);
    }

    public static MatchPosition getPreviousPosition() {
        currentPosition = currentPosition <= 0 ? 0 : --currentPosition;
        SpotlightSearchHelper.highlightCurrentPosition(styledText);
        return currentPosition >= 0 ? foundPositions.get(currentPosition) : null;
    }

    public static void highlightCurrentPosition(StyledText styledText) {
        SpotlightSearchHelper.resetHighlightingExceptCurrentPosition();
        if (currentPosition >= 0 && currentPosition < foundPositions.size()) {
            MatchPosition match = foundPositions.get(currentPosition);
            Display.getDefault().syncExec(() -> {
                if (!styledText.isDisposed() && matchPosition.start < styledText.getCharCount()) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = matchPosition.start;
                    styleRange.length = matchPosition.length;
                    styledText.setStyleRange(styleRange);
                    SpotlightSearchHelper.centerTextAtPosition(styledText, matchPosition.start + matchPosition.length / 2);
                    styledText.showSelection();
                }
            });
        }
    }

    public static void highlightWordAtPosition(StyledText styledText, MatchPosition match, int color) {
        Display.getDefault().asyncExec(() -> {
            if (!styledText.isDisposed() && matchPosition.start >= 0 && matchPosition.start + matchPosition.length <= styledText.getText().length()) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = matchPosition.start;
                styleRange.length = matchPosition.length;
                styleRange.background = Display.getCurrent().getSystemColor(color);
                styledText.setStyleRange(styleRange);
            }
        });
    }

    public static void resetHighlightingExceptCurrentPosition() {
        Display.getDefault().syncExec(() -> {
            if (!styledText.isDisposed()) {
                styledText.setStyleRange(null);
                int i = 0;
                while (i < foundPositions.size()) {
                    if (i != currentPosition) {
                        MatchPosition position = foundPositions.get(i);
                        SpotlightSearchHelper.highlightWordAtPosition(styledText, position, 7);
                    }
                    ++i;
                }
                if (currentPosition >= 0 && currentPosition < foundPositions.size()) {
                    MatchPosition currentMatch = foundPositions.get(currentPosition);
                    SpotlightSearchHelper.highlightWordAtPosition(styledText, currentMatch, 13);
                }
            }
        });
    }

    public static int getCurrentPosition() {
        return currentPosition;
    }

    public static int getTotalMatches() {
        return foundPositions.size();
    }

    public static void clearTotalMatches() {
        foundPositions.clear();
    }

    public static class MatchPosition {
        public int start;
        public int length;

        public MatchPosition(int start, int length) {
            this.start = start;
            this.length = length;
        }
    }
}

