/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IDocumentService;
import ch.elexis.core.text.ITextPlugin;
import ch.elexis.core.time.TimeUtil;
import ch.rgw.tools.StringTool;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RecipeDocumentTemplateReplacement
implements IDocumentService.IDirectTemplateReplacement {
    private boolean extended;
    private boolean takinglist;
    private String template;

    public RecipeDocumentTemplateReplacement(String template, boolean takinglist, boolean extended) {
        this.extended = extended;
        this.takinglist = takinglist;
        this.template = template;
    }

    public boolean replace(ITextPlugin textPlugin, IContext context) {
        IRecipe recipe = this.getIdentifiable(context).orElse(null);
        if (recipe != null) {
            List<IPrescription> lines = recipe.getPrescriptions();
            lines = lines.stream().filter(p -> p.getArticle() != null).collect(Collectors.toList());
            String[][] fields = new String[lines.size()][];
            if (this.extended) {
                int[] wt = new int[]{5, 45, 10, 10, 15, 15};
                fields = this.createExtendedTakingListFields(lines);
                textPlugin.insertTable(this.template, 0, fields, wt);
            } else {
                int[] wt = new int[]{10, 70, 20};
                fields = this.takinglist ? this.createTakingListFields(lines) : this.createRezeptListFields(lines);
                textPlugin.insertTable(this.template, 0, fields, wt);
            }
            return true;
        }
        return false;
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        Optional ret = context.getTyped(IRecipe.class);
        if (ret.isEmpty()) {
            ret = context.getNamed(this.template.substring(1, this.template.length() - 1));
        }
        return ret;
    }

    private String[][] createRezeptListFields(List<IPrescription> lines) {
        String[][] fields = new String[lines.size()][];
        int i = 0;
        while (i < fields.length) {
            IPrescription p = lines.get(i);
            fields[i] = new String[3];
            fields[i][0] = "";
            String bem = p.getRemark();
            fields[i][1] = StringTool.isNothing((Object)bem) ? p.getArticle().getLabel() : p.getArticle().getLabel() + "\t\r" + bem;
            fields[i][2] = p.getDosageInstruction();
            ++i;
        }
        return fields;
    }

    private String[][] createTakingListFields(List<IPrescription> lines) {
        String[][] fields = new String[lines.size()][];
        int i = 0;
        while (i < fields.length) {
            IPrescription p = lines.get(i);
            fields[i] = new String[3];
            fields[i][0] = "";
            String bem = p.getRemark();
            String patInfo = p.getDisposalComment();
            fields[i][1] = StringTool.isNothing((Object)bem) ? p.getArticle().getLabel() : (patInfo == null || patInfo.isEmpty() ? p.getArticle().getLabel() + "\t\r" + bem : p.getArticle().getLabel() + "\t\r" + bem + "\r" + patInfo);
            fields[i][2] = p.getDosageInstruction();
            ++i;
        }
        return fields;
    }

    private String[][] createExtendedTakingListFields(List<IPrescription> lines) {
        String[][] fields = new String[lines.size() + 1][];
        fields[0] = new String[6];
        fields[0][0] = "";
        fields[0][1] = "Medikament";
        fields[0][2] = "Einnahme";
        fields[0][3] = "Von bis und mit";
        fields[0][4] = "Anwendungsinstruktion";
        fields[0][5] = "Anwendungsgrund";
        int i = 1;
        while (i < fields.length) {
            IPrescription p = lines.get(i - 1);
            fields[i] = new String[6];
            fields[i][0] = p.getEntryType() != null && p.getEntryType() != EntryType.RECIPE && p.getEntryType() != EntryType.UNKNOWN ? p.getEntryType().name().substring(0, 1) : "";
            fields[i][1] = StringUtils.defaultString((String)p.getArticle().getLabel());
            fields[i][2] = StringUtils.defaultString((String)p.getDosageInstruction());
            fields[i][3] = StringUtils.defaultString((String)TimeUtil.DATE_GER.format(p.getDateFrom()));
            fields[i][4] = StringUtils.defaultString((String)p.getRemark());
            fields[i][5] = StringUtils.defaultString((String)p.getDisposalComment());
            ++i;
        }
        return fields;
    }
}

