/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.ee.json.WellKnownRcp;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.httpclient.HttpClientUtil;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.oauth2.OAuth2Service;
import ch.elexis.core.services.oauth2.RefreshAccessTokenTimerTask;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisEnvironmentService
implements IElexisEnvironmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String elexisEnvironmentHost;
    private IContextService contextService;
    private Timer refreshAccessTokenTimer;

    public ElexisEnvironmentService(String elexisEnvironmentHost, IContextService contextService) {
        this.elexisEnvironmentHost = elexisEnvironmentHost;
        this.contextService = contextService;
        LoggerFactory.getLogger(this.getClass()).info("Binding to EE {}", (Object)this.getHostname());
        this.refreshAccessTokenTimer = new Timer("Refresh EE access-token", true);
        this.refreshAccessTokenTimer.schedule((TimerTask)new RefreshAccessTokenTimerTask(contextService, this), 60000L, 60000L);
    }

    public String getVersion() {
        return "unknown";
    }

    public String getProperty(String key) {
        String value = System.getenv(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        value = System.getProperty(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        System.out.println("trying to fetch key " + key);
        throw new UnsupportedOperationException();
    }

    public WellKnownRcp getWellKnownRcp() {
        CloseableHttpClient closeableHttpClient = (CloseableHttpClient)OsgiServiceUtil.getService(CloseableHttpClient.class).get();
        try {
            String body = HttpClientUtil.getOrThrowAcceptJson((CloseableHttpClient)closeableHttpClient, (String)(this.getBaseUrl() + "/.well-known/elexis-rcp"));
            WellKnownRcp wellKnownRcp = (WellKnownRcp)new Gson().fromJson(body, WellKnownRcp.class);
            return wellKnownRcp;
        }
        catch (IOException e) {
            this.logger.warn("Error obtaining /.well-known/elexis-rcp returning defaults", (Throwable)e);
        }
        finally {
            OsgiServiceUtil.ungetService((Object)closeableHttpClient);
        }
        return new WellKnownRcp();
    }

    public JsonObject getStatus() {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getBaseUrl() + "/.status.json")).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return JsonParser.parseString((String)response.body()).getAsJsonObject();
        }
        catch (IOException | InterruptedException e) {
            this.logger.warn("Error obtaining status", (Throwable)e);
            return null;
        }
    }

    public String getHostname() {
        return this.elexisEnvironmentHost;
    }

    public void loadAccessToken(String username, char[] password) {
        String rcpClientSecret = this.getProperty("EE_RCP_OPENID_SECRET");
        ObjectStatus<AccessToken> accessToken = new OAuth2Service().performDirectAccessGrantFlow(URI.create(this.getKeycloakRealmEndpoint()), "elexis-rcp-openid", rcpClientSecret, username, password);
        if (accessToken.isOK()) {
            this.contextService.getRootContext().setTyped(accessToken.getObject());
            this.logger.info("Loaded access-token for [{}], valid until [{}], refresh until [{}]", new Object[]{((AccessToken)accessToken.getObject()).getUsername(), TimeUtil.toLocalDateTime((Date)((AccessToken)accessToken.getObject()).getAccessTokenExpiration()), TimeUtil.toLocalDateTime((Date)((AccessToken)accessToken.getObject()).refreshTokenExpiration())});
        } else {
            this.logger.warn("Could not load accessToken: " + accessToken.getMessage());
        }
    }
}

