/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.jpa.entities.Config;
import ch.elexis.core.jpa.entities.Userconfig;
import ch.elexis.core.jpa.entities.UserconfigId;
import ch.elexis.core.model.IConfig;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUserConfig;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ITraceService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.net.NetTool;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(name="LegacyConfigService", enabled=false)
public class ConfigService
implements IConfigService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IContextService contextService;
    @Reference
    private IAccessControlService accessControlService;
    public static final String LIST_SEPARATOR = ",";
    private Map<Object, LocalLock> managedLocks;
    @Reference
    private ITraceService traceService;

    @Activate
    public void activate() {
        this.accessControlService.doPrivileged(() -> {
            this.validateConfiguredDatabaseLocale();
            this.managedLocks = new HashMap<Object, LocalLock>();
        });
    }

    private void validateConfiguredDatabaseLocale() {
        Locale locale = Locale.getDefault();
        String dbStoredLocale = this.get("locale", null);
        if (dbStoredLocale == null || !locale.toString().equals(dbStoredLocale)) {
            LoggerFactory.getLogger(this.getClass()).error("System locale [{}] does not match database locale [{}].", (Object)locale.toString(), (Object)dbStoredLocale);
        }
    }

    public boolean set(String key, String value) {
        return this.set(key, value, true);
    }

    public boolean set(String key, String value, boolean addTraceEntry) {
        Optional entry = this.modelService.load(key, IConfig.class);
        if (value != null) {
            if (entry.isPresent()) {
                IConfig existing = (IConfig)entry.get();
                key = existing.getKey();
                if (Objects.equals(existing.getValue(), value)) {
                    return false;
                }
                existing.setValue(value);
                if (addTraceEntry) {
                    this.addTraceEntry("W globalCfg key [" + key + "] => value [" + value + "]");
                }
                this.modelService.save((Identifiable)existing);
                return true;
            }
            IConfig newEntry = (IConfig)this.modelService.create(IConfig.class);
            newEntry.setKey(key);
            newEntry.setValue(value);
            if (addTraceEntry) {
                this.addTraceEntry("W globalCfg key [" + key + "] => value [" + value + "]");
            }
            this.modelService.save((Identifiable)newEntry);
            return true;
        }
        if (entry.isPresent()) {
            if (addTraceEntry) {
                this.addTraceEntry("W globalCfg key [" + key + "] => removed");
            }
            this.modelService.remove((Identifiable)entry.get());
            return true;
        }
        return false;
    }

    private void addTraceEntry(String action) {
        String userId = this.contextService.getActiveUser().map(Identifiable::getId).orElse("unknown");
        this.traceService.addTraceEntry(userId, NetTool.hostname, action);
    }

    public boolean set(String key, boolean value) {
        return this.set(key, value ? "1" : "0");
    }

    public boolean set(String key, int value) {
        return this.set(key, Integer.toString(value));
    }

    public boolean set(IContact contact, String key, int value) {
        return this.set(contact, key, Integer.toString(value));
    }

    public boolean setFromList(String key, List<String> values) {
        String flattenedValue = values.stream().map(o -> o.toString()).reduce((u, t) -> u + LIST_SEPARATOR + t).get();
        return this.set(key, flattenedValue);
    }

    public String get(String key, String defaultValue, boolean refreshCache) {
        Optional configEntry = this.modelService.load(key, IConfig.class, false, refreshCache);
        return configEntry.map(IConfig::getValue).orElse(defaultValue);
    }

    public String getOrInsert(IContact contact, String key, Supplier<String> insertValue) {
        IElexisEntityManager elexisEntityManager = (IElexisEntityManager)OsgiServiceUtil.getService(IElexisEntityManager.class, null).get();
        EntityManager entityManager = (EntityManager)elexisEntityManager.getEntityManager(false);
        try {
            String ret;
            entityManager.getTransaction().begin();
            if (contact == null) {
                Config config = (Config)entityManager.find(Config.class, (Object)key);
                if (config == null) {
                    config = new Config();
                    config.setParam(key);
                    config.setWert(insertValue.get());
                    entityManager.persist((Object)config);
                }
                ret = config.getWert();
            } else {
                Userconfig userconfig = (Userconfig)entityManager.find(Userconfig.class, (Object)new UserconfigId(contact.getId(), key));
                if (userconfig == null) {
                    userconfig = new Userconfig();
                    userconfig.setOwnerId(contact.getId());
                    userconfig.setParam(key);
                    userconfig.setValue(insertValue.get());
                    entityManager.persist((Object)userconfig);
                }
                ret = userconfig.getValue();
            }
            entityManager.getTransaction().commit();
            String string = ret;
            return string;
        }
        finally {
            elexisEntityManager.closeEntityManager((Object)entityManager);
        }
    }

    public boolean get(String key, boolean defaultValue) {
        Optional configEntry = this.modelService.load(key, IConfig.class);
        return configEntry.map(IConfig::getValue).map(v -> "1".equals(v) || "true".equals(v)).orElse(defaultValue);
    }

    public int get(String key, int defaultValue) {
        return Integer.parseInt(this.get(key, Integer.toString(defaultValue)));
    }

    public List<String> getAsList(String key, List<String> defaultValue) {
        String val = this.get(key, null);
        if (val == null) {
            return defaultValue;
        }
        String[] split = val.split(LIST_SEPARATOR);
        return Stream.of(split).toList();
    }

    public boolean set(IContact contact, String key, String value) {
        Optional<Object> loaded = Optional.empty();
        if (contact != null) {
            INamedQuery configQuery = this.modelService.getNamedQuery(IUserConfig.class, true, new String[]{"ownerid", "param"});
            List configs = configQuery.executeWithParameters(configQuery.getParameterMap(new Object[]{"ownerid", contact.getId(), "param", key}));
            if (!configs.isEmpty()) {
                if (configs.size() > 1) {
                    LoggerFactory.getLogger(ConfigService.class).warn("Multiple user config entries for [{}] using first.", (Object)key);
                }
                loaded = Optional.of((IUserConfig)configs.get(0));
            }
            if (loaded.isPresent()) {
                if (value == null) {
                    this.addTraceEntry("W userCfg [" + contact.getId() + "] key [" + key + "] => removed");
                    this.modelService.remove((Identifiable)loaded.get());
                    return true;
                }
                String _value = ((IUserConfig)loaded.get()).getValue();
                if (Objects.equals(value, _value)) {
                    return true;
                }
                ((IUserConfig)loaded.get()).setValue(value);
                this.addTraceEntry("W userCfg [" + contact.getId() + "] key [" + key + "] => value [" + value + "]");
                this.modelService.save((Identifiable)loaded.get());
                return true;
            }
            if (value == null) {
                return false;
            }
            IUserConfig ret = (IUserConfig)this.modelService.create(IUserConfig.class);
            ret.setOwner(contact);
            ret.setKey(key);
            ret.setValue(value);
            this.addTraceEntry("W userCfg [" + contact.getId() + "] key [" + key + "] *> value [" + value + "]");
            this.modelService.save((Identifiable)ret);
            return true;
        }
        return false;
    }

    public boolean setActiveUserContact(String key, String value) {
        Optional activeUser = this.contextService.getActiveUserContact();
        if (activeUser.isPresent()) {
            return this.set((IContact)activeUser.get(), key, value);
        }
        LoggerFactory.getLogger(this.getClass()).warn("No active user available");
        return false;
    }

    public boolean setActiveUserContact(String key, boolean value) {
        Optional activeUser = this.contextService.getActiveUserContact();
        if (activeUser.isPresent()) {
            return this.set((IContact)activeUser.get(), key, value);
        }
        LoggerFactory.getLogger(this.getClass()).warn("No active user available");
        return false;
    }

    public boolean setActiveUserContact(String key, int value) {
        Optional activeUser = this.contextService.getActiveUserContact();
        if (activeUser.isPresent()) {
            return this.set((IContact)activeUser.get(), key, value);
        }
        LoggerFactory.getLogger(this.getClass()).warn("No active user available");
        return false;
    }

    public void setActiveUserContact(Map<Object, Object> map) {
        Optional activeUser = this.contextService.getActiveUserContact();
        if (activeUser.isPresent()) {
            this.setFromMap((IContact)activeUser.get(), map);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No active user available");
        }
    }

    public boolean set(IContact contact, String key, boolean value) {
        return this.set(contact, key, value ? "1" : "0");
    }

    public boolean setFromList(IContact contact, String key, List<String> values) {
        String flattenedValue = values.stream().map(o -> o.toString()).reduce((u, t) -> u + LIST_SEPARATOR + t).get();
        return this.set(contact, key, flattenedValue);
    }

    public String get(IContact contact, String key, String defaultValue, boolean refreshCache) {
        if (contact != null) {
            INamedQuery configQuery = CoreModelServiceHolder.get().getNamedQuery(IUserConfig.class, refreshCache, new String[]{"ownerid", "param"});
            Optional config = configQuery.executeWithParametersSingleResult(configQuery.getParameterMap(new Object[]{"ownerid", contact.getId(), "param", key}));
            if (config.isPresent()) {
                return ((IUserConfig)config.get()).getValue();
            }
        }
        return defaultValue;
    }

    public boolean get(IContact contact, String key, boolean defaultValue) {
        String value = this.get(contact, key, null);
        if (value != null) {
            return value.equals("1") || value.equalsIgnoreCase(Boolean.TRUE.toString());
        }
        return defaultValue;
    }

    public int get(IContact contact, String key, int defaultValue) {
        return Integer.parseInt(this.get(contact, key, Integer.toString(defaultValue)));
    }

    public List<String> getAsList(IContact contact, String key, List<String> defaultValue) {
        String val = this.get(contact, key, null);
        if (val == null) {
            return defaultValue;
        }
        String[] split = val.split(LIST_SEPARATOR);
        return Stream.of(split).toList();
    }

    public List<String> getSubNodes(String key, boolean refreshCache) {
        HashSet<String> ret = new HashSet<String>();
        IQuery query = CoreModelServiceHolder.get().getQuery(IConfig.class, refreshCache, false);
        query.and("param", IQuery.COMPARATOR.LIKE, (Object)(key + "/%"));
        List found = query.execute();
        for (IConfig iConfig : found) {
            String subNode = iConfig.getKey().substring(key.length() + 1);
            if (!StringUtils.isNotBlank((CharSequence)subNode) || subNode.indexOf(47) == -1) continue;
            ret.add(subNode.substring(0, subNode.indexOf(47)));
        }
        return new ArrayList<String>(ret);
    }

    public Map<Object, Object> getActiveUserContactAsMap() {
        if (this.contextService != null) {
            Optional activeUser = this.contextService.getActiveUserContact();
            if (activeUser.isPresent()) {
                return this.getAsMap((IContact)activeUser.get());
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("(getActiveUserContactAsMap) IContextService not available, returning null");
        }
        return null;
    }

    public Map<Object, Object> getAsMap(IContact contact) {
        if (contact == null) {
            throw new IllegalArgumentException();
        }
        IQuery query = CoreModelServiceHolder.get().getQuery(IUserConfig.class);
        query.and("ownerid", IQuery.COMPARATOR.EQUALS, (Object)contact.getId());
        List entries = query.execute();
        Map<Object, Object> ret = this.buildMap(entries);
        return ret;
    }

    private Map<Object, Object> buildMap(List<? extends IConfig> entries) {
        Hashtable<Object, Object> ret = new Hashtable<Object, Object>();
        for (IConfig iConfig : entries) {
            this.buildMap(iConfig.getKey(), iConfig.getValue(), ret);
        }
        return ret;
    }

    private void buildMap(String key, Object value, Map<Object, Object> map) {
        if (key.indexOf("/") != -1) {
            String currentKey = key.substring(0, key.indexOf("/"));
            Hashtable<Object, Object> subMap = (Hashtable<Object, Object>)map.get(currentKey);
            if (subMap == null) {
                subMap = new Hashtable<Object, Object>();
                map.put(currentKey, subMap);
            }
            this.buildMap(key.substring(key.indexOf("/") + 1), value, subMap);
        } else {
            map.put(key, value);
        }
    }

    public void setFromMap(IContact contact, Map<Object, Object> map) {
        map = this.flattenMap(map);
        map.forEach((k, v) -> this.set(contact, (String)k, (String)v));
    }

    private Map<Object, Object> flattenMap(Map<Object, Object> map) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        this.flattenMap(map, ret, "");
        return ret;
    }

    private void flattenMap(Map<Object, Object> src, Map<Object, Object> dest, String parentkey) {
        for (Object key : src.keySet()) {
            String currentKey;
            String string = currentKey = StringUtils.isEmpty((CharSequence)parentkey) ? (String)key : parentkey + "/" + String.valueOf(key);
            if (src.get(key) instanceof Map) {
                this.flattenMap((Map)src.get(key), dest, currentKey);
                continue;
            }
            dest.put(currentKey, src.get(key));
        }
    }

    public String getActiveMandator(String key, String defaultValue, boolean refreshCache) {
        if (this.contextService != null) {
            Optional activeMandator = this.contextService.getActiveMandator();
            if (activeMandator.isPresent()) {
                return this.get((IContact)activeMandator.get(), key, defaultValue, refreshCache);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("(getActiveMandator) IContextService not available, returning defaultValue for [{}]", (Object)key);
        }
        return defaultValue;
    }

    public void setActiveMandator(String key, String value) {
        Optional activeMandator = this.contextService.getActiveMandator();
        if (activeMandator.isPresent()) {
            this.set((IContact)activeMandator.get(), key, value);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No active mandator available");
        }
    }

    public void setActiveMandator(String key, boolean value) {
        Optional activeMandator = this.contextService.getActiveMandator();
        if (activeMandator.isPresent()) {
            this.set((IContact)activeMandator.get(), key, value);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No active mandator available");
        }
    }

    public String getActiveUserContact(String key, String defaultValue, boolean refreshCache) {
        if (this.contextService != null) {
            Optional activeUser = this.contextService.getActiveUserContact();
            if (activeUser.isPresent()) {
                return this.get((IContact)activeUser.get(), key, defaultValue, refreshCache);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("(getActiveUserContact) IContextService not available, returning defaultValue for [{}]", (Object)key);
        }
        return defaultValue;
    }

    public boolean getActiveMandator(String key, boolean defaultValue) {
        String defaultValueString = Boolean.toString(defaultValue);
        String result = this.getActiveMandator(key, defaultValueString);
        return result.equals("1") || result.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public boolean getActiveUserContact(String key, boolean defaultValue) {
        String defaultValueString = Boolean.toString(defaultValue);
        String result = this.getActiveUserContact(key, defaultValueString);
        return result.equals("1") || result.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public int getActiveUserContact(String key, int defaultValue) {
        if (this.contextService != null) {
            Optional activeUser = this.contextService.getActiveUserContact();
            if (activeUser.isPresent()) {
                return this.get((IContact)activeUser.get(), key, defaultValue);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("(getActiveUserContact) IContextService not available, returning defaultValue for [{}]", (Object)key);
        }
        return defaultValue;
    }

    public int getActiveMandator(String key, int defaultValue) {
        if (this.contextService != null) {
            Optional activeMandator = this.contextService.getActiveMandator();
            if (activeMandator.isPresent()) {
                return this.get((IContact)activeMandator.get(), key, defaultValue);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("(getActiveMandator) IContextService not available, returning defaultValue for [{}]", (Object)key);
        }
        return defaultValue;
    }

    public IConfigService.ILocalLock getLocalLock(Object object) {
        return new LocalLock(object);
    }

    public Optional<IConfigService.ILocalLock> getManagedLock(Object object) {
        return Optional.ofNullable((IConfigService.ILocalLock)this.managedLocks.get(object));
    }

    private class LocalLock
    implements IConfigService.ILocalLock {
        private String lockString;
        private Object lockObject;

        public LocalLock(Object object) {
            this.lockObject = object;
            if (object instanceof String) {
                this.lockString = "local_" + (String)object + "_lock";
            } else if (object instanceof Identifiable) {
                String storeToString = StoreToStringServiceHolder.getStoreToString(object);
                this.lockString = "local_" + storeToString + "_lock";
            } else {
                throw new IllegalStateException("Unknown object type [" + String.valueOf(object) + "]");
            }
        }

        public String getLockMessage() {
            String[] parts;
            Optional configEntry = ConfigService.this.modelService.load(this.lockString, IConfig.class);
            if (configEntry.isPresent() && ((IConfig)configEntry.get()).getValue() != null && (parts = ((IConfig)configEntry.get()).getValue().split("@")).length > 0) {
                return parts[0];
            }
            return "?";
        }

        public long getLockCurrentMillis() {
            String[] parts;
            Optional configEntry = ConfigService.this.modelService.load(this.lockString, IConfig.class);
            if (configEntry.isPresent() && ((IConfig)configEntry.get()).getValue() != null && (parts = ((IConfig)configEntry.get()).getValue().split("@")).length > 1) {
                return Long.parseLong(parts[1]);
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            Class<LocalLock> clazz = LocalLock.class;
            synchronized (LocalLock.class) {
                Optional configEntry = ConfigService.this.modelService.load(this.lockString, IConfig.class);
                if (configEntry.isPresent()) {
                    ConfigService.this.modelService.remove((Identifiable)configEntry.get());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasLock(String userName) {
            Class<LocalLock> clazz = LocalLock.class;
            synchronized (LocalLock.class) {
                Optional configEntry = ConfigService.this.modelService.load(this.lockString, IConfig.class);
                if (configEntry.isPresent()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ((IConfig)configEntry.get()).getValue().startsWith("[" + userName + "]@");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock() {
            Class<LocalLock> clazz = LocalLock.class;
            synchronized (LocalLock.class) {
                block5: {
                    Optional configEntry = ConfigService.this.modelService.load(this.lockString, IConfig.class);
                    if (!configEntry.isPresent()) break block5;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                String user = "system";
                Optional activeUserContact = ContextServiceHolder.get().getActiveUserContact();
                if (activeUserContact.isPresent()) {
                    user = ((IContact)activeUserContact.get()).getLabel();
                }
                IConfig _entry = (IConfig)ConfigService.this.modelService.create(IConfig.class);
                _entry.setKey(this.lockString);
                _entry.setValue("[" + user + "]@" + System.currentTimeMillis());
                ConfigService.this.modelService.save((Identifiable)_entry);
                ConfigService.this.managedLocks.put(this.lockObject, this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
    }
}

