/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.oauth2;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.services.oauth2.AccessTokenUtil;
import ch.elexis.core.services.oauth2.KeycloakAccessTokenResponse;
import ch.elexis.core.services.oauth2.PKCEUtil;
import ch.elexis.core.status.ObjectStatus;
import com.google.gson.Gson;
import jakarta.ws.rs.core.UriBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeFlowWithPKCE {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicReference<String> authorizationCode = new AtomicReference();
    private Thread redirectServerThread;
    private String clientId;
    private String redirectUri;
    private String pkceChallenge;
    private String pkceVerifier;

    public AuthorizationCodeFlowWithPKCE(String clientId) {
        this.clientId = clientId;
    }

    public URI initiateFlowGetBrowserUrl(URI authorizationUri, String clientSecret) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        int port = this.startClientRedirectUriServer();
        this.redirectUri = "http://localhost:" + port + "/callback";
        PKCEUtil pkceUtil = new PKCEUtil();
        this.pkceVerifier = pkceUtil.generateCodeVerifier();
        this.pkceChallenge = pkceUtil.generateCodeChallenge(this.pkceVerifier);
        UriBuilder requestUriBuilder = UriBuilder.fromUri((URI)authorizationUri);
        requestUriBuilder.queryParam("response_type", new Object[]{"code"});
        requestUriBuilder.queryParam("redirect_uri", new Object[]{this.redirectUri});
        requestUriBuilder.queryParam("code_challenge", new Object[]{this.pkceChallenge});
        requestUriBuilder.queryParam("code_challenge_method", new Object[]{"S256"});
        requestUriBuilder.queryParam("client_id", new Object[]{this.clientId});
        requestUriBuilder.queryParam("client_secret", new Object[]{clientSecret});
        return requestUriBuilder.build(new Object[0]);
    }

    public ObjectStatus<AccessToken> fetchAccessTokenAfterAuthorizationCode(Gson gson, String tokenEndpoint, String clientSecret) {
        while (this.authorizationCode.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error("Error wating for authorization code", (Throwable)e);
            }
        }
        this.shutdownServerThread();
        HttpPost httpPost = new HttpPost(tokenEndpoint);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "authorization_code"));
        params.add(new BasicNameValuePair("code", this.authorizationCode.get()));
        params.add(new BasicNameValuePair("code_verifier", this.pkceVerifier));
        params.add(new BasicNameValuePair("state", "state"));
        params.add(new BasicNameValuePair("client_id", this.clientId));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        params.add(new BasicNameValuePair("redirect_uri", this.redirectUri));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (CloseableHttpClient client = HttpClients.createDefault();){
                return (ObjectStatus)client.execute((ClassicHttpRequest)httpPost, res -> {
                    if (res.getCode() == 200) {
                        HttpEntity entity = res.getEntity();
                        String accessTokenResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        KeycloakAccessTokenResponse kcAccessTokenResponse = (KeycloakAccessTokenResponse)gson.fromJson(accessTokenResponse, KeycloakAccessTokenResponse.class);
                        AccessToken accessToken = AccessTokenUtil.load(kcAccessTokenResponse, tokenEndpoint.toString(), this.clientId);
                        return ObjectStatus.OK((Object)accessToken);
                    }
                    return ObjectStatus.ERROR((String)(res.getCode() + " " + res.getReasonPhrase()));
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return ObjectStatus.ERROR((String)e.getMessage());
        }
    }

    int startClientRedirectUriServer() {
        AtomicReference localPort = new AtomicReference();
        this.redirectServerThread = new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (ServerSocket serverSocket = new ServerSocket(0);){
                    serverSocket.setSoTimeout(500);
                    localPort.set(serverSocket.getLocalPort());
                    this.logger.debug("Listening on port " + String.valueOf(localPort.get()));
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            Throwable throwable2 = null;
                            Object var6_14 = null;
                            try (Socket accept = serverSocket.accept();){
                                boolean done = false;
                                Throwable throwable3 = null;
                                Object var10_20 = null;
                                try (BufferedReader in = new BufferedReader(new InputStreamReader(accept.getInputStream()));){
                                    Throwable throwable4 = null;
                                    Object var13_25 = null;
                                    try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(accept.getOutputStream()));){
                                        String callbackUri;
                                        Map<String, String> queryParameters;
                                        String _authorizationCode;
                                        String line = in.readLine();
                                        this.logger.debug("REQ " + line);
                                        if (line.startsWith("GET /callback") && StringUtils.isNotBlank((CharSequence)(_authorizationCode = (queryParameters = AuthorizationCodeFlowWithPKCE.getQueryParameters(callbackUri = line.split(" ")[1])).get("code")))) {
                                            this.logger.debug("Authorization code is [" + _authorizationCode + "]");
                                            this.authorizationCode.set(_authorizationCode);
                                            done = true;
                                        }
                                        int code = done ? 200 : 500;
                                        String body = "<HTML>" + code + "</HTML>";
                                        out.write("HTTP/1.0 " + code + "\r\n");
                                        out.write("Date: " + String.valueOf(LocalDateTime.now()) + "\r\n");
                                        out.write("Server: Custom Server\r\n");
                                        out.write("Content-Type: text/html\r\n");
                                        out.write("Content-Length: " + body.length() + "\r\n");
                                        out.write("\r\n");
                                        out.write(body);
                                        out.close();
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable4 == null) {
                                            throwable4 = throwable5;
                                        } else if (throwable4 != throwable5) {
                                            throwable4.addSuppressed(throwable5);
                                        }
                                        throw throwable4;
                                    }
                                }
                                catch (Throwable throwable6) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable6;
                                    } else if (throwable3 != throwable6) {
                                        throwable3.addSuppressed(throwable6);
                                    }
                                    throw throwable3;
                                }
                                if (!done) continue;
                            }
                            catch (Throwable throwable7) {
                                if (throwable2 == null) {
                                    throwable2 = throwable7;
                                } else if (throwable2 != throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                throw throwable2;
                            }
                        }
                        catch (URISyntaxException e) {
                            this.logger.error("Error in redirect call uri", (Throwable)e);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                    }
                    this.logger.debug("Stopped listening on port " + String.valueOf(localPort.get()));
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (ClosedByInterruptException e) {
                this.logger.debug("Closing connection due to interrupt");
            }
            catch (SocketException e) {
                if (Thread.interrupted()) {
                    this.logger.debug("Closing connection due to interrupt");
                } else {
                    this.logger.warn("Socket exception", (Throwable)e);
                }
            }
            catch (IOException e) {
                this.logger.error("Error in redirect server handler", (Throwable)e);
            }
        }, "oauth2-redirect-uri-server");
        this.redirectServerThread.start();
        while (localPort.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error("Error wating for server startup", (Throwable)e);
            }
        }
        return (Integer)localPort.get();
    }

    private static Map<String, String> getQueryParameters(String url) throws URISyntaxException {
        return new URIBuilder(new URI(url), StandardCharsets.UTF_8).getQueryParams().stream().collect(Collectors.toMap(NameValuePair::getName, nameValuePair -> URLDecoder.decode(nameValuePair.getValue(), StandardCharsets.UTF_8)));
    }

    private void shutdownServerThread() {
        if (this.redirectServerThread != null) {
            this.redirectServerThread.interrupt();
        }
        this.redirectServerThread = null;
    }

    public void abort() {
        this.shutdownServerThread();
    }
}

