/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eedep;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.myelexis.server.api.UserApi;
import ch.myelexis.server.client.ApiException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="EEDependentConfigService", enabled=false)
public class ConfigService
implements IConfigService {
    @Reference
    UserApi userApi;
    @Reference
    IContextService contextService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LIST_SEPARATOR = ",";

    public String get(String key, String defaultValue, boolean refreshCache) {
        try {
            String _value = this.userApi.getGlobalConfigurationValueByKey(key);
            return Objects.toString(_value, defaultValue);
        }
        catch (ApiException e) {
            this.logger.error("Could not get key " + key, (Throwable)e);
            return defaultValue;
        }
    }

    public boolean get(String key, boolean defaultValue) {
        String v = this.get(key, Boolean.toString(defaultValue), false);
        return "1".equals(v) || "true".equals(v);
    }

    public int get(String key, int defaultValue) {
        String v = this.get(key, Integer.toString(defaultValue), false);
        return Integer.parseInt(v);
    }

    public List<String> getAsList(String key, List<String> defaultValue) {
        String val = this.get(key, null);
        if (val == null) {
            return defaultValue;
        }
        String[] split = val.split(LIST_SEPARATOR);
        return Stream.of(split).toList();
    }

    public String getActiveUserContact(String key, String defaultValue, boolean refreshCache) {
        try {
            String _value = this.userApi.getUserContactConfigurationValueByKey(key, null);
            return Objects.toString(_value, defaultValue);
        }
        catch (ApiException e) {
            this.logger.error("Could not getActiveUserContact " + key, (Throwable)e);
            return defaultValue;
        }
    }

    public boolean getActiveUserContact(String key, boolean defaultValue) {
        String v = this.getActiveUserContact(key, Boolean.toString(defaultValue), false);
        return "1".equals(v) || "true".equals(v);
    }

    public int getActiveUserContact(String key, int defaultValue) {
        String v = this.getActiveUserContact(key, Integer.toString(defaultValue), false);
        return Integer.parseInt(v);
    }

    public String get(IContact contact, String key, String defaultValue, boolean refreshCache) {
        if (Objects.equals(contact.getId(), this.contextService.getActiveUserContact().map(Identifiable::getId).orElse(null))) {
            return this.getActiveUserContact(key, defaultValue, refreshCache);
        }
        try {
            String _value = this.userApi.getUserContactConfigurationValueByKey(contact.getId(), null);
            return Objects.toString(_value, defaultValue);
        }
        catch (ApiException e) {
            this.logger.error("Could not get " + contact.getId() + " " + key, (Throwable)e);
            throw new UnsupportedOperationException("requires ict-adminstrator if non self");
        }
    }

    public boolean get(IContact contact, String key, boolean defaultValue) {
        String v = this.get(contact, key, Boolean.toString(defaultValue), false);
        return "1".equals(v) || "true".equals(v);
    }

    public int get(IContact contact, String key, int defaultValue) {
        String v = this.get(contact, key, Integer.toString(defaultValue), false);
        return Integer.parseInt(v);
    }

    public List<String> getAsList(IContact contact, String key, List<String> defaultValue) {
        String val = this.get(contact, key, null);
        if (val == null) {
            return defaultValue;
        }
        String[] split = val.split(LIST_SEPARATOR);
        return Stream.of(split).toList();
    }

    public List<String> getSubNodes(String key, boolean refreshCache) {
        try {
            return this.userApi.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key);
        }
        catch (ApiException e) {
            this.logger.error("Could not getSubNodes " + key, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getActiveMandator(String key, String defaultValue, boolean refreshCache) {
        return this.get(this.contextService.getActiveMandator().orElse(null), key, defaultValue, refreshCache);
    }

    public boolean getActiveMandator(String key, boolean defaultValue) {
        String v = this.getActiveMandator(key, Boolean.toString(defaultValue), false);
        return "1".equals(v) || "true".equals(v);
    }

    public int getActiveMandator(String key, int defaultValue) {
        String v = this.getActiveMandator(key, Integer.toString(defaultValue), false);
        return Integer.parseInt(v);
    }

    public boolean set(String key, String value) {
        try {
            if (value == null) {
                this.userApi.deleteGlobalConfigurationValueByKey(key);
                this.contextService.sendEvent("info/elexis/config/delete", (Object)("global/" + key));
            } else {
                this.userApi.setGlobalConfigurationValueByKey(key, value);
                this.contextService.sendEvent("info/elexis/config/update", (Object)("global/" + key));
            }
            return true;
        }
        catch (ApiException e) {
            this.logger.error("Could not set/delete global key " + key, (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, String value, boolean addTraceEntry) {
        return this.set(key, value);
    }

    public boolean set(String key, boolean value) {
        return this.set(key, Boolean.toString(value), false);
    }

    public boolean set(String key, int value) {
        return this.set(key, Integer.toString(value), false);
    }

    public boolean set(IContact contact, String key, int value) {
        return this.set(contact, key, Integer.toString(value));
    }

    public boolean set(IContact contact, String key, String value) {
        if (Objects.equals(contact.getId(), this.contextService.getActiveUserContact().map(Identifiable::getId).orElse(null))) {
            return this.setActiveUserContact(key, value);
        }
        throw new UnsupportedOperationException("May only set values for oneself");
    }

    public void setActiveMandator(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void setActiveMandator(String key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean setActiveUserContact(String key, String value) {
        try {
            if (value == null) {
                this.userApi.deleteUserContactConfigurationEntryByKey(key);
                this.contextService.sendEvent("info/elexis/config/delete", (Object)("user/" + key));
            } else {
                this.userApi.setUserContactConfigurationValueByKey(key, value);
                this.contextService.sendEvent("info/elexis/config/update", (Object)("user/" + key));
            }
        }
        catch (ApiException e) {
            this.logger.error("Could not setActiveUserContact " + key, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setActiveUserContact(String key, int value) {
        return this.setActiveUserContact(key, Integer.toString(value));
    }

    public boolean setActiveUserContact(String key, boolean value) {
        return this.setActiveUserContact(key, Boolean.toString(value));
    }

    public boolean set(IContact contact, String key, boolean value) {
        return this.set(contact, key, value);
    }

    public boolean setFromList(String key, List<String> values) {
        String flattenedValue = values.stream().map(o -> o.toString()).reduce((u, t) -> u + LIST_SEPARATOR + t).get();
        return this.set(key, flattenedValue);
    }

    public boolean setFromList(IContact contact, String key, List<String> values) {
        String flattenedValue = values.stream().map(o -> o.toString()).reduce((u, t) -> u + LIST_SEPARATOR + t).get();
        return this.set(contact, key, flattenedValue);
    }

    public void setActiveUserContact(Map<Object, Object> map) {
        throw new UnsupportedOperationException();
    }

    public String getOrInsert(IContact contact, String key, Supplier<String> insertValue) {
        throw new UnsupportedOperationException();
    }

    public Map<Object, Object> getAsMap(IContact contact) {
        throw new UnsupportedOperationException("requires ict-adminstrator if non self");
    }

    public Map<Object, Object> getActiveUserContactAsMap() {
        throw new UnsupportedOperationException();
    }

    public void setFromMap(IContact person, Map<Object, Object> map) {
        throw new UnsupportedOperationException();
    }

    public IConfigService.ILocalLock getLocalLock(Object object) {
        throw new UnsupportedOperationException();
    }

    public Optional<IConfigService.ILocalLock> getManagedLock(Object object) {
        throw new UnsupportedOperationException();
    }
}

