/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class EigenleistungCodeElementService
implements ICodeElementServiceContribution {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public String getSystem() {
        return "Eigenleistung";
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        INamedQuery query = this.coreModelService.getNamedQuery(ICustomService.class, new String[]{"code"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"code", code}));
        if (!found.isEmpty()) {
            if (found.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).warn("Found more than one " + this.getSystem() + " with code [" + code + "] using first");
            }
            return Optional.of((ICodeElement)found.get(0));
        }
        return this.coreModelService.load(code, ICustomService.class);
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        return this.coreModelService.getQuery(ICustomService.class).execute();
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.SERVICE;
    }
}

