/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Money;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class IEncounterServiceTest
extends AbstractServiceTest {
    private IEncounter encounter;
    private IEncounterService encounterService = (IEncounterService)OsgiServiceUtil.getService(IEncounterService.class).get();
    private IBillingService billingService = (IBillingService)OsgiServiceUtil.getService(IBillingService.class).get();

    @Before
    public void before() {
        this.createTestMandantPatientFallBehandlung();
        this.encounter = (IEncounter)this.testEncounters.get(0);
    }

    @After
    public void after() {
        this.cleanup();
    }

    @Ignore(value="QUARANTINE #24743")
    @Test
    public void multiThreadUpdate() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(3);
        int i = 0;
        while (i < 100) {
            int number = i++;
            executor.execute(() -> {
                ContextServiceHolder.get().setActiveUser(AllServiceTests.getUser());
                ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
                ICustomService service = (ICustomService)coreModelService.create(ICustomService.class);
                service.setCode("code" + number);
                service.setNetPrice(new Money(number));
                service.setPrice(new Money(number));
                service.setText("test" + number);
                coreModelService.save((Identifiable)service);
                this.billingService.bill((IBillable)service, this.encounter, 1.0);
            });
            executor.execute(() -> this.encounterService.updateVersionedEntry(this.encounter, "Test consultation\nmulti update " + number, "Administrator"));
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        coreModelService.refresh((Identifiable)this.encounter, true);
        Assert.assertEquals((long)100L, (long)this.encounter.getBilled().size());
        Assert.assertTrue((this.encounter.getVersionedEntry().getHeadVersion() > 1 ? 1 : 0) != 0);
        IQuery query = coreModelService.getQuery(ICustomService.class);
        for (ICustomService service : query.execute()) {
            coreModelService.remove((Identifiable)service);
        }
    }

    @Test
    public void getLatestEncounter() {
        ICoverage iCoverage = (ICoverage)this.testCoverages.get(0);
        this.testCoverages.remove(iCoverage);
        coreModelService.remove((Identifiable)iCoverage);
        IEncounter iEncounter = (IEncounter)this.testEncounters.get(0);
        this.testEncounters.remove(iEncounter);
        coreModelService.remove((Identifiable)iEncounter);
        Optional encounter = this.encounterService.getLatestEncounter((IPatient)this.testPatients.get(0));
        Assert.assertFalse((boolean)encounter.isPresent());
        encounter = this.encounterService.getLatestEncounter((IPatient)this.testPatients.get(0), true);
        Assert.assertTrue((boolean)encounter.isPresent());
        Assert.assertNotNull((Object)((IEncounter)encounter.get()).getCoverage());
        Assert.assertEquals(this.testPatients.get(0), (Object)((IEncounter)encounter.get()).getPatient());
        coreModelService.remove((Identifiable)((IEncounter)encounter.get()).getCoverage());
        coreModelService.remove((Identifiable)encounter.get());
    }
}

