/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.serial;

import ch.elexis.core.utils.CoreUtil;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements SerialPortDataListener {
    public static final int STX = 2;
    public static final int ETX = 3;
    private static Logger logger = LoggerFactory.getLogger(Connection.class);
    private ComPortListener listener;
    private String myPort;
    private String[] mySettings;
    private String name;
    private SerialPort serialPort;
    private byte[] startOfChunk;
    private List<byte[]> endOfChunk;
    private ByteArrayOutputStream buffer;
    private boolean excludeDelimiters = false;
    private boolean writeDataBufferDebugFile = false;

    public Connection(String portName, String port, String settings, ComPortListener l) {
        this.listener = l;
        this.myPort = port;
        this.mySettings = settings.split(",");
        this.name = portName;
        logger.info("SerialPort config: [" + portName + "][" + port + "][" + settings + "]");
    }

    public boolean connect() {
        try {
            this.openConnection();
            return this.serialPort != null && this.serialPort.isOpen();
        }
        catch (Exception ex) {
            logger.error("Exception on connect", (Throwable)ex);
            return false;
        }
    }

    public Connection withEndOfChunk(byte[] ... endOfChunk) {
        this.endOfChunk = endOfChunk != null ? Arrays.asList(endOfChunk) : null;
        return this;
    }

    public Connection withStartOfChunk(byte[] startOfChunk) {
        this.startOfChunk = startOfChunk;
        return this;
    }

    public void openConnection() {
        this.serialPort = SerialPort.getCommPort((String)this.myPort);
        if (this.serialPort != null) {
            this.setConnectionParameters();
            if (this.serialPort.openPort()) {
                this.serialPort.addDataListener((SerialPortDataListener)this);
            }
        } else {
            logger.warn("No serial port [" + this.myPort + "] found.");
        }
    }

    public void setConnectionParameters() {
        this.serialPort.setComPortParameters(Integer.parseInt(this.mySettings[0]), Integer.parseInt(this.mySettings[1]), Integer.parseInt(this.mySettings[3]), this.getParity(this.mySettings[2]));
        int flowControl = -1;
        if (this.mySettings.length >= 5 && this.mySettings[4] != null && this.mySettings.length >= 6 && this.mySettings[5] != null) {
            flowControl = this.getFlowControl(this.mySettings[4]);
        }
        if (this.mySettings.length >= 6 && this.mySettings[5] != null) {
            flowControl |= this.getFlowControl(this.mySettings[5]);
        }
        if (flowControl > -1) {
            this.serialPort.setFlowControl(flowControl);
        }
    }

    private int getFlowControl(String string) {
        try {
            int value = Integer.parseInt(string);
            if (value == 2) {
                value = 16;
            } else if (value == 4) {
                value = 65536;
            } else if (value == 8) {
                value = 0x100000;
            }
            return value;
        }
        catch (NumberFormatException e) {
            logger.warn("Non numeric flow control [" + string + "]");
            return -1;
        }
    }

    private int getParity(String parity) {
        if (parity.equalsIgnoreCase("Even")) {
            return 2;
        }
        if (parity.equalsIgnoreCase("Odd")) {
            return 1;
        }
        return 0;
    }

    public void serialEvent(SerialPortEvent e) {
        if (e.getEventType() == 1) {
            byte[] newData = new byte[this.serialPort.bytesAvailable()];
            int numRead = this.serialPort.readBytes(newData, newData.length);
            if (numRead != newData.length) {
                logger.warn("Failed to read [" + newData.length + "] bytes, got [" + numRead + "]");
            }
            this.setData(newData);
        }
    }

    protected void setData(byte[] newData) {
        if (this.endOfChunk != null) {
            try {
                if (this.buffer == null) {
                    this.buffer = new ByteArrayOutputStream();
                }
                this.buffer.write(newData);
                while (this.hasChunk(this.buffer)) {
                    byte[] bytes = this.buffer.toByteArray();
                    for (byte[] bs : this.endOfChunk) {
                        int endIndex = this.indexOf(bytes, bs);
                        if (endIndex == -1) continue;
                        this.fireData(this.getChunk(bytes, bs, endIndex));
                        this.buffer = new ByteArrayOutputStream();
                        if (bytes.length <= endIndex + bs.length) continue;
                        this.buffer.write(Arrays.copyOfRange(bytes, endIndex + bs.length, bytes.length));
                    }
                }
                if (this.writeDataBufferDebugFile) {
                    this.writeDebugBuffer();
                }
            }
            catch (Exception ex) {
                logger.error("Exception buffering chunk", (Throwable)ex);
            }
        } else {
            this.fireData(newData);
        }
    }

    private void writeDebugBuffer() {
        File userDir = CoreUtil.getWritableUserDir();
        File bufferOutput = new File(userDir, "serailbuffer_debug.bin");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fout = new FileOutputStream(bufferOutput);){
                fout.write(this.buffer.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Could not write serailbuffer_debug.bin", (Throwable)e);
        }
        logger.info("Wrote [" + bufferOutput.getAbsolutePath() + "] with size [" + bufferOutput.length() + "]");
    }

    protected void fireData(byte[] data) {
        if (data != null && data.length > 0) {
            this.listener.gotData(this, data);
            this.fireChunk(new String(data));
        }
    }

    protected void fireChunk(String chunk) {
        if (StringUtils.isNotBlank((CharSequence)chunk)) {
            logger.info("Serial chunk [" + chunk + "]");
            this.listener.gotChunk(this, chunk);
        }
    }

    private boolean hasChunk(ByteArrayOutputStream buffer) {
        for (byte[] bs : this.endOfChunk) {
            if (this.indexOf(buffer.toByteArray(), bs) == -1) continue;
            return true;
        }
        return false;
    }

    private byte[] getChunk(byte[] buffer, byte[] matchingEndOfChunk, int endIndex) {
        if (this.startOfChunk != null) {
            int startIndex = this.indexOf(buffer, this.startOfChunk);
            if (startIndex == -1) {
                startIndex = 0;
            }
            if (this.excludeDelimiters) {
                byte[] chunkBytes = Arrays.copyOfRange(buffer, startIndex + this.startOfChunk.length, endIndex);
                int startOffset = this.getStartOffset(chunkBytes);
                return Arrays.copyOfRange(chunkBytes, startOffset, chunkBytes.length);
            }
            return Arrays.copyOfRange(buffer, startIndex, endIndex + matchingEndOfChunk.length);
        }
        if (this.excludeDelimiters) {
            return Arrays.copyOfRange(buffer, 0, endIndex);
        }
        return Arrays.copyOfRange(buffer, 0, endIndex + matchingEndOfChunk.length);
    }

    private int getStartOffset(byte[] buffer) {
        int ret = 0;
        int offset = this.indexOf(buffer, this.startOfChunk);
        while (offset != -1) {
            ret = ret + offset + this.startOfChunk.length;
            buffer = Arrays.copyOfRange(buffer, offset + this.startOfChunk.length, buffer.length);
            offset = this.indexOf(buffer, this.startOfChunk);
        }
        return ret;
    }

    private int indexOf(byte[] array, byte[] target) {
        if (target.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < array.length - target.length + 1) {
            block4: {
                int j = 0;
                while (j < target.length) {
                    if (array[i + j] == target[j]) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void close() {
        this.close(1000);
    }

    public void close(final int sleepTime) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(sleepTime);
                    Connection.this.serialPort.closePort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        this.listener.closed();
    }

    public boolean isOpen() {
        return this.serialPort != null && this.serialPort.isOpen();
    }

    public boolean send(byte[] bytes) {
        return this.serialPort.writeBytes(bytes, bytes.length) == bytes.length;
    }

    public boolean send(String data) {
        try {
            return this.send(data.getBytes());
        }
        catch (Exception ex) {
            logger.error("Exception sending data [" + data + "]");
            return false;
        }
    }

    public void sendBreak() {
        if (this.serialPort != null) {
            this.serialPort.setBreak();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serialPort.clearBreak();
        }
    }

    public static String[] getComPorts() {
        ArrayList<String> p = new ArrayList<String>();
        try {
            SerialPort[] serialPortArray = SerialPort.getCommPorts();
            int n = serialPortArray.length;
            int n2 = 0;
            while (n2 < n) {
                SerialPort serialPort = serialPortArray[n2];
                p.add(serialPort.getSystemPortName());
                ++n2;
            }
        }
        catch (Exception ex) {
            logger.error("Exception getting comm ports ", (Throwable)ex);
        }
        return p.toArray(new String[p.size()]);
    }

    public String getName() {
        return this.name;
    }

    public ComPortListener getListener() {
        return this.listener;
    }

    public String getMyPort() {
        return this.myPort;
    }

    public int getListeningEvents() {
        return 1;
    }

    public Connection excludeDelimiters(boolean excludeDelimiters) {
        this.excludeDelimiters = excludeDelimiters;
        return this;
    }

    public Connection writeDataBufferDebugFile(boolean value) {
        this.writeDataBufferDebugFile = value;
        return this;
    }

    public static interface ComPortListener {
        default public void gotChunk(Connection conn, String chunk) {
        }

        default public void gotData(Connection conn, byte[] data) {
        }

        public void closed();
    }
}

