/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.pdfbox.ui.parts.handlers;

import ch.elexis.core.pdfbox.ui.parts.handlers.PDFTextExtractor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PDFLabelMouseListener {
    private Map<Integer, List<Rectangle>> markedAreasPerPage;
    private String selectionText = "";
    private Image[] images;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private Image[] labelBackgrounds;
    private GC[] gcBackgrounds;
    private PDFTextExtractor pdfTextExtractor;
    private Menu menu;
    private String finalText;
    private Rectangle currentSelection;

    public PDFLabelMouseListener(Map<Integer, List<Rectangle>> markedAreasPerPage, Image[] images, Image[] labelBackgrounds, GC[] gcBackgrounds, PDFTextExtractor pdfTextExtractor) {
        this.markedAreasPerPage = markedAreasPerPage;
        this.images = images;
        this.labelBackgrounds = labelBackgrounds;
        this.gcBackgrounds = gcBackgrounds;
        this.pdfTextExtractor = pdfTextExtractor;
        this.currentSelection = null;
    }

    public void addMouseListenersToLabel(final Label label, final int pageIndex, final int j) {
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    if ((e.stateMask & 0x40000) == 0) {
                        PDFLabelMouseListener.this.clearSelection(pageIndex);
                        label.redraw();
                    }
                    PDFLabelMouseListener.this.startX = e.x;
                    PDFLabelMouseListener.this.startY = e.y;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    PDFLabelMouseListener.this.endX = e.x;
                    PDFLabelMouseListener.this.endY = e.y;
                    if (PDFLabelMouseListener.this.startX != PDFLabelMouseListener.this.endX && PDFLabelMouseListener.this.startY != PDFLabelMouseListener.this.endY) {
                        if (PDFLabelMouseListener.this.currentSelection != null) {
                            PDFLabelMouseListener.this.markedAreasPerPage.computeIfAbsent(pageIndex, k -> new ArrayList()).add(PDFLabelMouseListener.this.currentSelection);
                            PDFLabelMouseListener.this.currentSelection = null;
                        }
                        String test1 = PDFLabelMouseListener.this.pdfTextExtractor.extractTextFromMarkedAreas();
                        PDFLabelMouseListener.this.markedAreasPerPage.clear();
                        PDFLabelMouseListener.this.adjustSelectionToEndOfLine(pageIndex, PDFLabelMouseListener.this.startX, PDFLabelMouseListener.this.startY, PDFLabelMouseListener.this.endX, PDFLabelMouseListener.this.endY);
                        String test2 = PDFLabelMouseListener.this.pdfTextExtractor.extractTextFromMarkedAreas();
                        PDFLabelMouseListener.this.finalText = PDFLabelMouseListener.this.trimToMatch(test1, test2);
                        PDFLabelMouseListener.this.showContextMenu(label, PDFLabelMouseListener.this.endX, PDFLabelMouseListener.this.endY);
                    }
                    label.redraw();
                }
                if (e.button == 3) {
                    PDFLabelMouseListener.this.clearSelection(pageIndex);
                    label.redraw();
                }
            }
        });
        label.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if ((e.stateMask & 0x80000) != 0) {
                    int oldEndX = PDFLabelMouseListener.this.endX;
                    int oldEndY = PDFLabelMouseListener.this.endY;
                    PDFLabelMouseListener.this.endX = e.x;
                    PDFLabelMouseListener.this.endY = e.y;
                    PDFLabelMouseListener.this.currentSelection = new Rectangle(Math.min(PDFLabelMouseListener.this.startX, PDFLabelMouseListener.this.endX), Math.min(PDFLabelMouseListener.this.startY, PDFLabelMouseListener.this.endY), Math.abs(PDFLabelMouseListener.this.endX - PDFLabelMouseListener.this.startX), Math.abs(PDFLabelMouseListener.this.endY - PDFLabelMouseListener.this.startY));
                    label.redraw(Math.min(PDFLabelMouseListener.this.startX, oldEndX), Math.min(PDFLabelMouseListener.this.startY, oldEndY), Math.abs(oldEndX - PDFLabelMouseListener.this.startX), Math.abs(oldEndY - PDFLabelMouseListener.this.startY), false);
                    label.redraw(Math.min(PDFLabelMouseListener.this.startX, PDFLabelMouseListener.this.endX), Math.min(PDFLabelMouseListener.this.startY, PDFLabelMouseListener.this.endY), Math.abs(PDFLabelMouseListener.this.endX - PDFLabelMouseListener.this.startX), Math.abs(PDFLabelMouseListener.this.endY - PDFLabelMouseListener.this.startY), false);
                }
            }
        });
        label.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Color highlightColor;
                if (PDFLabelMouseListener.this.labelBackgrounds[j] == null) {
                    PDFLabelMouseListener.this.labelBackgrounds[j] = new Image((Device)Display.getDefault(), PDFLabelMouseListener.this.images[j].getBounds());
                    PDFLabelMouseListener.this.gcBackgrounds[j] = new GC((Drawable)PDFLabelMouseListener.this.labelBackgrounds[j]);
                    PDFLabelMouseListener.this.gcBackgrounds[j].drawImage(PDFLabelMouseListener.this.images[j], 0, 0);
                    PDFLabelMouseListener.this.gcBackgrounds[j].dispose();
                    PDFLabelMouseListener.this.gcBackgrounds[j] = null;
                }
                e.gc.drawImage(PDFLabelMouseListener.this.labelBackgrounds[j], 0, 0, PDFLabelMouseListener.this.labelBackgrounds[j].getBounds().width, PDFLabelMouseListener.this.labelBackgrounds[j].getBounds().height, 0, 0, label.getSize().x, label.getSize().y);
                List<Rectangle> markedAreas = PDFLabelMouseListener.this.markedAreasPerPage.get(pageIndex);
                if (markedAreas != null) {
                    highlightColor = new Color((Device)Display.getDefault(), 0, 0, 255);
                    try {
                        e.gc.setBackground(highlightColor);
                        e.gc.setAlpha(30);
                        for (Rectangle rect : markedAreas) {
                            e.gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                        }
                    }
                    finally {
                        highlightColor.dispose();
                    }
                }
                if (PDFLabelMouseListener.this.currentSelection != null) {
                    highlightColor = new Color((Device)Display.getDefault(), 0, 0, 255);
                    try {
                        e.gc.setBackground(highlightColor);
                        e.gc.setAlpha(30);
                        e.gc.fillRectangle(PDFLabelMouseListener.this.currentSelection.x, PDFLabelMouseListener.this.currentSelection.y, PDFLabelMouseListener.this.currentSelection.width, PDFLabelMouseListener.this.currentSelection.height);
                    }
                    finally {
                        highlightColor.dispose();
                    }
                }
            }
        });
        label.addDisposeListener(e -> {
            if (this.labelBackgrounds[j] != null && !this.labelBackgrounds[j].isDisposed()) {
                this.labelBackgrounds[j].dispose();
                this.labelBackgrounds[n] = null;
            }
        });
    }

    public void disposeResources() {
        int i = 0;
        while (i < this.labelBackgrounds.length) {
            if (this.labelBackgrounds[i] != null && !this.labelBackgrounds[i].isDisposed()) {
                this.labelBackgrounds[i].dispose();
            }
            if (this.gcBackgrounds[i] != null && !this.gcBackgrounds[i].isDisposed()) {
                this.gcBackgrounds[i].dispose();
            }
            ++i;
        }
    }

    private void adjustSelectionToEndOfLine(int pageIndex, int startX, int startY, int endX, int endY) {
        int adjustedEndX = this.images[pageIndex].getBounds().width - 1;
        int y = startY;
        while (y < endY) {
            int bottomY = y + 28;
            if (bottomY >= endY) {
                this.currentSelection = new Rectangle(startX, y, endX - startX, endY - y);
                this.markedAreasPerPage.computeIfAbsent(pageIndex, k -> new ArrayList()).add(this.currentSelection);
                this.currentSelection = null;
            } else {
                this.currentSelection = new Rectangle(startX, y, adjustedEndX - startX, 20);
                this.markedAreasPerPage.computeIfAbsent(pageIndex, k -> new ArrayList()).add(this.currentSelection);
                startX = 0;
            }
            y += 20;
        }
    }

    private String trimToMatch(String shortText, String longText) {
        String lastLine = this.getLastLine(shortText);
        int endIndex = longText.lastIndexOf(lastLine);
        if (endIndex != -1) {
            String trimmedText;
            this.finalText = trimmedText = longText.substring(0, endIndex + lastLine.length()).trim();
            return trimmedText;
        }
        return longText;
    }

    private String getLastLine(String text) {
        String[] lines = text.split("\\r?\\n");
        if (lines.length > 0) {
            return lines[lines.length - 1].trim();
        }
        return text;
    }

    public void clearSelection(int pageIndex) {
        this.startX = 0;
        this.startY = 0;
        this.endX = 0;
        this.endY = 0;
        this.currentSelection = null;
        if (pageIndex >= 0) {
            this.markedAreasPerPage.remove(pageIndex);
        } else {
            this.markedAreasPerPage.clear();
        }
    }

    private void showContextMenu(Label label, int x, int y) {
        this.menu = new Menu((Decorations)label.getShell(), 8);
        MenuItem copyItem = new MenuItem(this.menu, 8);
        copyItem.setText("Kopieren");
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean validSelection = PDFLabelMouseListener.this.markedAreasPerPage.values().stream().flatMap(Collection::stream).anyMatch(rect -> rect.width > 0 && rect.height > 0);
                String textToCopy = !validSelection ? PDFLabelMouseListener.this.pdfTextExtractor.extractTextFromDocument() : (PDFLabelMouseListener.this.selectionText = PDFLabelMouseListener.this.finalText);
                if (!textToCopy.isEmpty()) {
                    Clipboard clipboard = new Clipboard(Display.getDefault());
                    clipboard.setContents(new Object[]{textToCopy}, new Transfer[]{TextTransfer.getInstance()});
                    clipboard.dispose();
                }
                PDFLabelMouseListener.this.clearSelection(-1);
                PDFLabelMouseListener.this.menu.dispose();
            }
        });
        this.menu.setLocation(label.toDisplay(x, y));
        this.menu.setVisible(true);
    }
}

