/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.util.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractModelService;
import ch.elexis.core.model.IConfig;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserConfig;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.service.CoreModelAdapterFactory;
import ch.elexis.core.model.service.holder.ContextServiceHolder;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.service.holder.StoreToStringServiceHolder;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtil {
    private static Logger logger = LoggerFactory.getLogger(ModelUtil.class);
    private static final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter defaultDateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public static boolean isConfig(String key, boolean defaultValue) {
        Optional loaded = CoreModelServiceHolder.get().load(key, IConfig.class);
        if (loaded.isPresent()) {
            String value = ((IConfig)loaded.get()).getValue();
            return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1"));
        }
        return defaultValue;
    }

    public static boolean isUserConfig(IContact owner, String key, boolean defaultValue) {
        if (owner != null) {
            String value;
            INamedQuery configQuery = CoreModelServiceHolder.get().getNamedQuery(IUserConfig.class, true, new String[]{"ownerid", "param"});
            List configs = configQuery.executeWithParameters(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", key}));
            if (configs.isEmpty()) {
                return defaultValue;
            }
            IConfig config = (IConfig)configs.get(0);
            if (configs.size() > 1) {
                logger.warn("Multiple user config entries for [" + key + "] using first.");
            }
            return (value = config.getValue()) != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1"));
        }
        logger.warn("No user contact for query of key [" + key + "] returning default");
        return defaultValue;
    }

    public static String getConfig(String key, String defaultValue) {
        IQuery configQuery = CoreModelServiceHolder.get().getQuery(IConfig.class);
        configQuery.and((EStructuralFeature)ModelPackage.Literals.ICONFIG__KEY, IQuery.COMPARATOR.EQUALS, (Object)key);
        List configs = configQuery.execute();
        if (configs.isEmpty()) {
            return defaultValue;
        }
        IConfig config = (IConfig)configs.get(0);
        if (configs.size() > 1) {
            logger.warn("Multiple config entries for [" + key + "] using first.");
        }
        return config.getValue();
    }

    public static Optional<IContact> getActiveUserContact() {
        if (ContextServiceHolder.isPresent()) {
            Optional ret = ContextServiceHolder.get().getActiveUserContact();
            if (ret.isPresent()) {
                return ret;
            }
            Optional user = ContextServiceHolder.get().getActiveUser();
            if (user.isPresent()) {
                return Optional.ofNullable(((IUser)user.get()).getAssignedContact());
            }
        } else {
            logger.warn("No IContextService available.");
        }
        return Optional.empty();
    }

    public static <T> IQuery<T> getQuery(Class<T> interfaceClazz) {
        return CoreModelServiceHolder.get().getQuery(interfaceClazz);
    }

    public static <T> T load(String objectId, Class<T> clazz) {
        Optional ret = CoreModelServiceHolder.get().load(objectId, clazz);
        return ret.orElse(null);
    }

    public static <T> T getAdapter(EntityWithId entity, Class<T> clazz) {
        return ModelUtil.getAdapter(entity, clazz, false);
    }

    public static <T> T getAdapter(EntityWithId entity, Class<T> clazz, boolean registerEntityChangeEvent) {
        if (entity != null) {
            Optional adapter = CoreModelAdapterFactory.getInstance().getModelAdapter(entity, clazz, true, registerEntityChangeEvent);
            return adapter.orElse(null);
        }
        return null;
    }

    public static boolean verifyUsernameNotTaken(String username) {
        return !CoreModelServiceHolder.get().load(username, IUser.class).isPresent();
    }

    public static AbstractModelService getModelService() {
        return (AbstractModelService)CoreModelServiceHolder.get();
    }

    public static Optional<Identifiable> getFromStoreToString(String storeToString) {
        return StoreToStringServiceHolder.get().loadFromString(storeToString);
    }

    public static Optional<String> getStoreToString(Identifiable identifiable) {
        return StoreToStringServiceHolder.get().storeToString(identifiable);
    }

    public static IDiagnosisReference getOrCreateDiagnosisReference(IDiagnosis diagnosis) {
        Optional storeToString = StoreToStringServiceHolder.get().storeToString((Identifiable)diagnosis);
        if (storeToString.isPresent()) {
            String[] parts = ((String)storeToString.get()).split("::");
            INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IDiagnosisReference.class, true, new String[]{"code", "diagnosisClass"});
            List existing = query.executeWithParameters(query.getParameterMap(new Object[]{"code", diagnosis.getCode(), "diagnosisClass", parts[0]}));
            if (!existing.isEmpty()) {
                return (IDiagnosisReference)existing.get(0);
            }
            IDiagnosisReference reference = (IDiagnosisReference)CoreModelServiceHolder.get().create(IDiagnosisReference.class);
            reference.setCode(diagnosis.getCode());
            reference.setReferredClass(parts[0]);
            reference.setText(diagnosis.getText());
            CoreModelServiceHolder.get().save((Identifiable)reference);
            return reference;
        }
        return null;
    }

    public static String toString(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(yyyyMMdd);
    }

    public static LocalDate toLocalDate(String dateValue) {
        if (dateValue == null || dateValue.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(dateValue, yyyyMMdd);
        }
        catch (DateTimeParseException e) {
            logger.warn("Error parsing [{}]", (Object)dateValue, (Object)e);
            return null;
        }
    }

    public static String getPersonalia(Kontakt kontakt) {
        StringBuilder sb = new StringBuilder(64);
        if (kontakt != null) {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{kontakt.getDescription1()})) {
                sb.append(kontakt.getDescription1());
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                sb.append(" ");
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{kontakt.getDescription2()})) {
                sb.append(kontakt.getDescription2());
            }
            if (kontakt.getDob() != null) {
                sb.append(" ").append(defaultDateFormatter.format(kontakt.getDob()));
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{kontakt.getTitel()})) {
                sb.append(",").append(kontakt.getTitel());
            }
        }
        return sb.toString();
    }
}

