/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.Contact;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.MaritalStatus;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

public class Person
extends Contact
implements IPerson {
    public Person(Kontakt model) {
        super(model);
    }

    public Gender getGender() {
        return ((Kontakt)this.getEntity()).getGender();
    }

    public void setGender(Gender value) {
        ((Kontakt)this.getEntityMarkDirty()).setGender(value);
    }

    public String getTitel() {
        return ((Kontakt)this.getEntity()).getTitel();
    }

    public void setTitel(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setTitel(value);
    }

    public String getTitelSuffix() {
        return ((Kontakt)this.getEntity()).getTitelSuffix();
    }

    public void setTitelSuffix(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setTitelSuffix(value);
    }

    public String getFirstName() {
        return ((Kontakt)this.getEntity()).getDescription2();
    }

    public LocalDateTime getDateOfBirth() {
        if (((Kontakt)this.getEntity()).getDob() != null) {
            return ((Kontakt)this.getEntity()).getDob().atStartOfDay();
        }
        return null;
    }

    public void setDateOfBirth(LocalDateTime value) {
        ((Kontakt)this.getEntityMarkDirty()).setDob(value != null ? value.toLocalDate() : null);
    }

    public LocalDateTime getDateOfDeath() {
        if (((Kontakt)this.getEntity()).getDod() != null) {
            return ((Kontakt)this.getEntity()).getDod().atStartOfDay();
        }
        return null;
    }

    public void setDateOfDeath(LocalDateTime value) {
        ((Kontakt)this.getEntityMarkDirty()).setDod(value.toLocalDate());
    }

    public void setFirstName(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setDescription2(value);
    }

    public String getLastName() {
        return ((Kontakt)this.getEntity()).getDescription1();
    }

    public void setLastName(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setDescription1(value);
    }

    public int getAgeInYears() {
        LocalDateTime dateOfBirth = this.getDateOfBirth();
        if (dateOfBirth != null) {
            LocalDate now = LocalDate.now();
            long years = ChronoUnit.YEARS.between(dateOfBirth.toLocalDate(), now);
            return (int)years;
        }
        return -1;
    }

    public long getAgeAtIn(LocalDateTime reference, ChronoUnit chronoUnit) {
        return chronoUnit.between(this.getDateOfBirth(), reference);
    }

    public MaritalStatus getMaritalStatus() {
        Object extInfo = this.getExtInfo("MaritalStatus");
        if (extInfo != null) {
            return MaritalStatus.byNumericSafe((String)((String)extInfo));
        }
        return null;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.setExtInfo("MaritalStatus", maritalStatus != null ? Integer.toString(maritalStatus.numericValue()) : null);
    }

    public IContact getLegalGuardian() {
        Object legalGuardianId = this.getExtInfo("LegalGuardian");
        if (legalGuardianId instanceof String) {
            Optional owner = CoreModelServiceHolder.get().load((String)legalGuardianId, IContact.class);
            return owner.orElse(null);
        }
        return null;
    }

    public void setLegalGuardian(IContact value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            this.setExtInfo("LegalGuardian", value.getId());
        } else if (value == null) {
            this.setExtInfo("LegalGuardian", null);
        }
    }

    @Override
    public String getLabel() {
        return PersonFormatUtil.getPersonalia((IPerson)this);
    }
}

