/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XidTest {
    private IModelService modelService;
    private IContact contact1;
    private IContact contact2;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.contact1 = (IContact)this.modelService.create(IContact.class);
        this.contact1.setDescription1("test contact 1");
        this.modelService.save((Identifiable)this.contact1);
        this.contact2 = (IContact)this.modelService.create(IContact.class);
        this.contact2.setDescription1("test contact 2");
        this.modelService.save((Identifiable)this.contact2);
    }

    @After
    public void after() {
        this.modelService.remove((Identifiable)this.contact1);
        this.modelService.remove((Identifiable)this.contact2);
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void create() {
        IXid xid = (IXid)this.modelService.create(IXid.class);
        Assert.assertNotNull((Object)xid);
        Assert.assertTrue((boolean)(xid instanceof IXid));
        xid.setDomain("http://www.test.info");
        xid.setDomainId("testId");
        xid.setObject((Object)this.contact1);
        this.modelService.save((Identifiable)xid);
        Optional loadedXid = this.modelService.load(xid.getId(), IXid.class);
        Assert.assertTrue((boolean)loadedXid.isPresent());
        Assert.assertFalse((xid == loadedXid.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)xid, loadedXid.get());
        Assert.assertEquals((Object)this.contact1, (Object)((IXid)loadedXid.get()).getObject(IContact.class));
        this.modelService.remove((Identifiable)xid);
    }

    @Test
    public void query() {
        IXid xid1 = (IXid)this.modelService.create(IXid.class);
        xid1.setDomain("http://www.test.info");
        xid1.setDomainId("testId1");
        xid1.setObject((Object)this.contact1);
        this.modelService.save((Identifiable)xid1);
        IXid xid2 = (IXid)this.modelService.create(IXid.class);
        xid2.setDomain("http://www.test.info");
        xid2.setDomainId("testId2");
        xid2.setObject((Object)this.contact2);
        this.modelService.save((Identifiable)xid2);
        IQuery query = this.modelService.getQuery(IXid.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IXID__DOMAIN, IQuery.COMPARATOR.EQUALS, (Object)"http://www.test.info");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)2L, (long)existing.size());
        for (IXid iXid : existing) {
            IContact contact = (IContact)iXid.getObject(IContact.class);
            Assert.assertNotNull((Object)contact);
            if (iXid.getDomainId().endsWith("1")) {
                Assert.assertEquals((Object)this.contact1, (Object)contact);
                Assert.assertEquals((Object)this.contact1.getXid("http://www.test.info").getId(), (Object)iXid.getId());
                continue;
            }
            if (!iXid.getDomainId().endsWith("2")) continue;
            Assert.assertEquals((Object)this.contact2, (Object)contact);
            Assert.assertEquals((Object)this.contact2.getXid("http://www.test.info").getId(), (Object)iXid.getId());
        }
        this.modelService.remove((Identifiable)xid1);
        this.modelService.remove((Identifiable)xid2);
    }

    @Test
    public void queryAhvUnified() {
        IXid xid1 = (IXid)this.modelService.create(IXid.class);
        xid1.setDomain("www.ahv.ch/xid");
        xid1.setDomainId("756.1234.1234.56");
        xid1.setObject((Object)this.contact1);
        this.modelService.save((Identifiable)xid1);
        INamedQuery namedQuery = this.modelService.getNamedQuery(IXid.class, new String[]{"ahvdomainid"});
        List xids = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"ahvdomainid", "7561234123456"}));
        Assert.assertEquals((Object)this.contact1.getId(), (Object)((IContact)((IXid)xids.get(0)).getObject(IContact.class)).getId());
        xids = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"ahvdomainid", "756.1234.123456"}));
        Assert.assertEquals((Object)this.contact1.getId(), (Object)((IContact)((IXid)xids.get(0)).getObject(IContact.class)).getId());
    }
}

