/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.test.AbstractTest;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MandatorTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createMandator();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void extInfoWithRefetch() {
        Assert.assertTrue((boolean)this.mandator.isMandator());
        Assert.assertTrue((this.mandator.getExtInfo((Object)"testKey") == null ? 1 : 0) != 0);
        this.mandator.setMobile("011");
        this.mandator.setExtInfo((Object)"testKey", (Object)"testValue");
        Optional loaded = this.coreModelService.load(this.mandator.getId(), IMandator.class);
        Assert.assertTrue((((IMandator)loaded.get()).getMobile() == null ? 1 : 0) != 0);
        Assert.assertTrue((((IMandator)loaded.get()).getExtInfo((Object)"testKey") == null ? 1 : 0) != 0);
        this.coreModelService.save((Identifiable)this.mandator);
        Assert.assertEquals((Object)"011", (Object)((IMandator)loaded.get()).getMobile());
        Assert.assertEquals((Object)"testValue", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey"));
    }

    @Test
    public void extInfoWithoutRefetch() {
        Assert.assertTrue((boolean)this.mandator.isMandator());
        Assert.assertTrue((this.mandator.getExtInfo((Object)"testKey") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.mandator.getMobile() == null ? 1 : 0) != 0);
        this.mandator.setMobile("01");
        this.mandator.setExtInfo((Object)"testKey", (Object)"testValue");
        Optional loaded = this.coreModelService.load(this.mandator.getId(), IMandator.class);
        this.coreModelService.save((Identifiable)this.mandator);
        Assert.assertEquals((Object)"01", (Object)((IMandator)loaded.get()).getMobile());
        Assert.assertEquals((Object)"testValue", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey"));
    }

    @Test
    public void extInfoMutlipleSaveAndRefresh() {
        Assert.assertTrue((boolean)this.mandator.isMandator());
        Assert.assertTrue((this.mandator.getExtInfo((Object)"testKey") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.mandator.getMobile() == null ? 1 : 0) != 0);
        this.mandator.setMobile("01");
        this.mandator.setExtInfo((Object)"testKey1", (Object)"testValue1");
        Optional loaded = this.coreModelService.load(this.mandator.getId(), IMandator.class);
        this.coreModelService.save((Identifiable)this.mandator);
        Assert.assertEquals((Object)"01", (Object)((IMandator)loaded.get()).getMobile());
        Assert.assertEquals((Object)"testValue1", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey1"));
        this.mandator.setExtInfo((Object)"testKey2", (Object)"testValue2");
        this.mandator.setExtInfo((Object)"testKey3", (Object)"testValue3");
        this.mandator.setMobile("02");
        CoreModelServiceHolder.get().refresh((Identifiable)this.mandator);
        loaded = this.coreModelService.load(this.mandator.getId(), IMandator.class);
        CoreModelServiceHolder.get().refresh((Identifiable)loaded.get());
        Assert.assertTrue((this.mandator.getExtInfo((Object)"testKey2") != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"02", (Object)this.mandator.getMobile());
        Assert.assertTrue((((IMandator)loaded.get()).getExtInfo((Object)"testKey2") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"01", (Object)((IMandator)loaded.get()).getMobile());
        this.coreModelService.save((Identifiable)this.mandator);
        Assert.assertEquals((Object)"02", (Object)((IMandator)loaded.get()).getMobile());
        Assert.assertEquals((Object)"testValue1", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey1"));
        Assert.assertEquals((Object)"testValue2", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey2"));
        Assert.assertEquals((Object)"testValue3", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey3"));
        CoreModelServiceHolder.get().refresh((Identifiable)loaded.get());
        Assert.assertEquals((Object)"02", (Object)((IMandator)loaded.get()).getMobile());
        Assert.assertEquals((Object)"testValue1", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey1"));
        Assert.assertEquals((Object)"testValue2", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey2"));
        Assert.assertEquals((Object)"testValue3", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey3"));
        loaded = this.coreModelService.load(this.mandator.getId(), IMandator.class);
        Assert.assertEquals((Object)"02", (Object)((IMandator)loaded.get()).getMobile());
        Assert.assertEquals((Object)"testValue1", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey1"));
        Assert.assertEquals((Object)"testValue2", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey2"));
        Assert.assertEquals((Object)"testValue3", (Object)((IMandator)loaded.get()).getExtInfo((Object)"testKey3"));
    }

    @Test
    public void getSetIsActiveMandator() {
        Assert.assertTrue((boolean)this.mandator.isActive());
        this.mandator.setActive(false);
        this.coreModelService.save((Identifiable)this.mandator);
        Assert.assertFalse((boolean)this.mandator.isActive());
        this.mandator.setActive(true);
        this.coreModelService.save((Identifiable)this.mandator);
        Assert.assertTrue((boolean)this.mandator.isActive());
    }
}

