/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LaboratoryTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void create() {
        ILaboratory laboratory = (ILaboratory)this.coreModelService.create(ILaboratory.class);
        Assert.assertNotNull((Object)laboratory);
        Assert.assertTrue((boolean)(laboratory instanceof ILaboratory));
        Assert.assertTrue((boolean)laboratory.isLaboratory());
        laboratory.setCode("TestLab");
        laboratory.setDescription1("Laboratory Test");
        this.coreModelService.save((Identifiable)laboratory);
        Optional loadedLaboratory = this.coreModelService.load(laboratory.getId(), ILaboratory.class);
        Assert.assertTrue((boolean)loadedLaboratory.isPresent());
        Assert.assertFalse((laboratory == loadedLaboratory.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)laboratory, loadedLaboratory.get());
        Assert.assertEquals((Object)laboratory.getCode(), (Object)((ILaboratory)loadedLaboratory.get()).getCode());
        Assert.assertEquals((Object)laboratory.getDescription1(), (Object)((ILaboratory)loadedLaboratory.get()).getDescription1());
        this.coreModelService.remove((Identifiable)laboratory);
    }

    @Test
    public void query() {
        ILaboratory laboratory1 = (ILaboratory)this.coreModelService.create(ILaboratory.class);
        laboratory1.setCode("TestLab1");
        laboratory1.setDescription1("Laboratory Test 1");
        this.coreModelService.save((Identifiable)laboratory1);
        ILaboratory laboratory2 = (ILaboratory)this.coreModelService.create(ILaboratory.class);
        laboratory2.setCode("TestLab2");
        laboratory2.setDescription1("Laboratory Test 2");
        this.coreModelService.save((Identifiable)laboratory2);
        IQuery query = this.coreModelService.getQuery(ILaboratory.class);
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__CODE, IQuery.COMPARATOR.LIKE, (Object)"%TestLab%");
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)"%TestLab%");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)2L, (long)existing.size());
        query = this.coreModelService.getQuery(ILaboratory.class);
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__CODE, IQuery.COMPARATOR.LIKE, (Object)"%Lab1%");
        query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)"%Lab1%");
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertEquals((Object)laboratory1.getCode(), (Object)((ILaboratory)existing.get(0)).getCode());
        Assert.assertEquals((Object)laboratory1.getDescription1(), (Object)((ILaboratory)existing.get(0)).getDescription1());
        this.coreModelService.remove((Identifiable)laboratory1);
        this.coreModelService.remove((Identifiable)laboratory2);
    }
}

