/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class CoverageTest
extends AbstractTest {
    public void before() {
        super.before();
        this.createPatient();
        this.createCoverage();
    }

    public void after() {
        super.after();
    }

    @Test
    public void createFindDeleteCoverage() {
        Assert.assertTrue((boolean)this.patient.getCoverages().contains(this.coverage));
        Assert.assertEquals((Object)this.patient, (Object)this.coverage.getPatient());
        Assert.assertEquals((Object)"testCoverage", (Object)this.coverage.getDescription());
        Assert.assertEquals((Object)"testReason", (Object)this.coverage.getReason());
        Assert.assertEquals((Object)"KVG", (Object)this.coverage.getBillingSystem().getName());
        Assert.assertNotNull((Object)this.coverage.getDateFrom());
        Assert.assertNull((Object)this.coverage.getDateTo());
        IQuery query = this.coreModelService.getQuery(ICoverage.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
        Assert.assertEquals((Object)this.coverage, query.executeSingleResult().get());
        this.coreModelService.delete((Deleteable)this.coverage);
        Assert.assertFalse((boolean)this.patient.getCoverages().contains(this.coverage));
    }

    @Test
    public void coverageOpenClose() {
        Assert.assertTrue((boolean)this.coverage.isOpen());
        this.coverage.setDateTo(LocalDate.now().minus(1L, ChronoUnit.DAYS));
        this.coreModelService.save((Identifiable)this.coverage);
        Assert.assertFalse((boolean)this.coverage.isOpen());
    }
}

