/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class BillingSystemFactorTest
extends AbstractTest {
    @Test
    public void create() {
        IBillingSystemFactor factor = (IBillingSystemFactor)this.coreModelService.create(IBillingSystemFactor.class);
        Assert.assertNotNull((Object)factor);
        Assert.assertTrue((boolean)(factor instanceof IBillingSystemFactor));
        factor.setSystem("testsystem");
        factor.setFactor(0.98);
        factor.setValidFrom(LocalDate.of(2000, 1, 1));
        factor.setValidTo(LocalDate.of(9999, 12, 31));
        this.coreModelService.save((Identifiable)factor);
        Optional loadedFactor = this.coreModelService.load(factor.getId(), IBillingSystemFactor.class);
        Assert.assertTrue((boolean)loadedFactor.isPresent());
        Assert.assertFalse((factor == loadedFactor.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)factor, loadedFactor.get());
        Assert.assertEquals((double)factor.getFactor(), (double)((IBillingSystemFactor)loadedFactor.get()).getFactor(), (double)0.001);
        this.coreModelService.remove((Identifiable)factor);
    }

    @Test
    public void query() {
        IBillingSystemFactor factor = (IBillingSystemFactor)this.coreModelService.create(IBillingSystemFactor.class);
        factor.setSystem("testsystem");
        factor.setFactor(0.98);
        factor.setValidFrom(LocalDate.of(2000, 1, 1));
        factor.setValidTo(LocalDate.of(9999, 12, 31));
        this.coreModelService.save((Identifiable)factor);
        IBillingSystemFactor factor1 = (IBillingSystemFactor)this.coreModelService.create(IBillingSystemFactor.class);
        factor1.setSystem("testsystem");
        factor1.setFactor(0.9);
        factor1.setValidFrom(LocalDate.of(1990, 1, 1));
        factor1.setValidTo(LocalDate.of(1999, 12, 31));
        this.coreModelService.save((Identifiable)factor1);
        IQuery query = this.coreModelService.getQuery(IBillingSystemFactor.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)"testsystem");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)2L, (long)existing.size());
        query = this.coreModelService.getQuery(IBillingSystemFactor.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)"testsystem");
        query.and((EStructuralFeature)ModelPackage.Literals.IBILLING_SYSTEM_FACTOR__VALID_TO, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.of(2000, 1, 1));
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertEquals((double)factor.getFactor(), (double)((IBillingSystemFactor)existing.get(0)).getFactor(), (double)0.001);
        this.coreModelService.remove((Identifiable)factor);
        this.coreModelService.remove((Identifiable)factor1);
    }
}

