/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.ArticleTyp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArticleTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createLocalArticle();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void create() {
        Assert.assertNotNull((Object)this.localArticle);
        Assert.assertTrue((boolean)(this.localArticle instanceof IArticle));
        Optional loaded = this.coreModelService.load(this.localArticle.getId(), IArticle.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertEquals((Object)"123456789", (Object)((IArticle)loaded.get()).getCode());
        Assert.assertEquals((Object)ArticleTyp.EIGENARTIKEL, (Object)((IArticle)loaded.get()).getTyp());
        Assert.assertEquals((Object)"0000001111111", (Object)((IArticle)loaded.get()).getGtin());
        Assert.assertEquals((long)12L, (long)((IArticle)loaded.get()).getPackageSize());
        Assert.assertEquals((long)12L, (long)((IArticle)loaded.get()).getSellingSize());
    }

    @Test
    public void product() {
        IArticle product = (IArticle)this.coreModelService.create(IArticle.class);
        product.setName("test product");
        product.setTyp(ArticleTyp.ARTIKEL);
        IArticle article = (IArticle)this.coreModelService.create(IArticle.class);
        article.setName("test article 1");
        article.setCode("123456789");
        article.setTyp(ArticleTyp.ARTIKEL);
        article.setGtin("0000001111111");
        article.setPackageSize(12);
        article.setSellingSize(12);
        article.setProduct(product);
        IArticle article1 = (IArticle)this.coreModelService.create(IArticle.class);
        article1.setName("test article 2");
        article1.setCode("987654321");
        article1.setTyp(ArticleTyp.ARTIKEL);
        article1.setGtin("1111112222222");
        article1.setPackageSize(24);
        article1.setSellingSize(24);
        article1.setProduct(product);
        this.coreModelService.save(Arrays.asList(product, article, article1));
        Optional loaded = this.coreModelService.load(product.getId(), IArticle.class);
        Assert.assertFalse((boolean)((IArticle)loaded.get()).getPackages().isEmpty());
        Assert.assertTrue((boolean)((IArticle)loaded.get()).getPackages().contains(article));
        Assert.assertTrue((boolean)((IArticle)loaded.get()).getPackages().contains(article1));
        Assert.assertEquals(loaded.get(), (Object)article.getProduct());
        Assert.assertEquals(loaded.get(), (Object)article1.getProduct());
        List packages = product.getPackages();
        packages.forEach(p -> p.setProduct(null));
        this.coreModelService.save(packages);
        this.coreModelService.remove((Identifiable)product);
        loaded = this.coreModelService.load(article.getId(), IArticle.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertTrue((((IArticle)loaded.get()).getProduct() == null ? 1 : 0) != 0);
        this.coreModelService.remove((Identifiable)article);
        this.coreModelService.remove((Identifiable)article1);
    }

    @Test
    public void query() {
        IArticle article1 = (IArticle)this.coreModelService.create(IArticle.class);
        article1.setName("test article 1");
        article1.setCode("987654321");
        article1.setTyp(ArticleTyp.EIGENARTIKEL);
        article1.setGtin("1111112222222");
        article1.setPackageSize(24);
        article1.setSellingSize(24);
        this.coreModelService.save((Identifiable)article1);
        IQuery query = this.coreModelService.getQuery(IArticle.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__GTIN, IQuery.COMPARATOR.EQUALS, (Object)"0000001111111");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((Object)this.localArticle, existing.get(0));
        query = this.coreModelService.getQuery(IArticle.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__TYP, IQuery.COMPARATOR.EQUALS, (Object)ArticleTyp.EIGENARTIKEL);
        existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)2L, (long)existing.size());
        this.coreModelService.remove((Identifiable)this.localArticle);
        this.coreModelService.remove((Identifiable)article1);
    }
}

