/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IVaccination;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IVaccinationBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import java.time.LocalDate;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VaccinationTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createPatient();
        this.createLocalArticle();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createFindDelete() {
        IVaccination vaccination = (IVaccination)new IVaccinationBuilder(this.coreModelService, null, this.localArticle, this.patient).buildAndSave();
        Assert.assertEquals((Object)this.patient, (Object)vaccination.getPatient());
        Assert.assertEquals((Object)this.localArticle, (Object)vaccination.getArticle());
        Assert.assertNotNull((Object)vaccination.getDateOfAdministration());
        List vaccinations = this.coreModelService.getQuery(IVaccination.class).and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION").execute();
        Assert.assertEquals((Object)vaccination, vaccinations.get(0));
        this.coreModelService.remove((Identifiable)vaccination);
    }

    @Test
    public void patientGetVaccination() {
        IVaccination vaccination = (IVaccination)new IVaccinationBuilder(this.coreModelService, null, "vaccinationName", "0123456789012", "J07BK03", this.patient).dateOfAdministration(LocalDate.of(2000, 1, 1)).buildAndSave();
        Assert.assertEquals((Object)this.patient, (Object)vaccination.getPatient());
        Assert.assertNull((Object)vaccination.getArticle());
        Assert.assertEquals((Object)"vaccinationName", (Object)vaccination.getArticleName());
        Assert.assertEquals((Object)LocalDate.of(2000, 1, 1), (Object)vaccination.getDateOfAdministration());
        List vaccinations = this.coreModelService.getQuery(IVaccination.class).and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION").and((EStructuralFeature)ModelPackage.Literals.IVACCINATION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this.patient).execute();
        Assert.assertEquals((Object)vaccination, vaccinations.get(0));
        this.coreModelService.remove((Identifiable)vaccination);
    }
}

