/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUserConfig;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserConfigTest {
    private IModelService modelService;
    private IContact contact1;
    private IContact contact2;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.contact1 = (IContact)this.modelService.create(IContact.class);
        this.contact1.setDescription1("test contact 1");
        this.modelService.save((Identifiable)this.contact1);
        this.contact2 = (IContact)this.modelService.create(IContact.class);
        this.contact2.setDescription1("test contact 2");
        this.modelService.save((Identifiable)this.contact2);
    }

    @After
    public void after() {
        this.modelService.remove((Identifiable)this.contact1);
        this.modelService.remove((Identifiable)this.contact2);
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void create() {
        IUserConfig config = (IUserConfig)this.modelService.create(IUserConfig.class);
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)(config instanceof IUserConfig));
        config.setOwner(this.contact1);
        config.setKey("test key1");
        config.setValue("test value 1");
        this.modelService.save((Identifiable)config);
        this.modelService.remove((Identifiable)config);
    }

    @Test
    public void query() {
        IUserConfig config1 = (IUserConfig)this.modelService.create(IUserConfig.class);
        config1.setOwner(this.contact1);
        config1.setKey("test key 1");
        config1.setValue("test value 1");
        this.modelService.save((Identifiable)config1);
        IUserConfig config2 = (IUserConfig)this.modelService.create(IUserConfig.class);
        config2.setOwner(this.contact2);
        config2.setKey("test key 2");
        config2.setValue("test value 2");
        this.modelService.save((Identifiable)config2);
        IQuery query = this.modelService.getQuery(IUserConfig.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IUSER_CONFIG__OWNER, IQuery.COMPARATOR.EQUALS, (Object)this.contact2.getId());
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((long)1L, (long)existing.size());
        Assert.assertFalse((config2 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)config2, existing.get(0));
        Assert.assertEquals((Object)config2.getValue(), (Object)((IUserConfig)existing.get(0)).getValue());
        this.modelService.remove((Identifiable)config1);
        this.modelService.remove((Identifiable)config2);
    }
}

