/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IReminderResponsibleLink;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IUserGroupBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.test.AbstractTest;
import java.io.IOException;
import java.time.LocalDate;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReminderTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createMandator();
        super.createPatient();
        super.createPerson();
    }

    @Test
    public void createDeleteReminder() throws IOException {
        IReminder reminder = (IReminder)this.coreModelService.create(IReminder.class);
        reminder.setContact((IContact)this.patient);
        reminder.setCreator((IContact)this.mandator);
        reminder.addResponsible((IContact)this.mandator);
        reminder.addResponsible((IContact)this.person);
        reminder.setSubject("test");
        this.coreModelService.save((Identifiable)reminder);
        reminder = this.coreModelService.load(reminder.getId(), IReminder.class).orElse(null);
        Assert.assertNotNull((Object)reminder);
        Assert.assertEquals(this.coreModelService.load(this.patient.getId(), IContact.class).get(), (Object)reminder.getContact());
        Assert.assertEquals((long)2L, (long)reminder.getResponsible().size());
        Assert.assertTrue((boolean)reminder.getResponsible().contains(this.coreModelService.load(this.person.getId(), IContact.class).get()));
        this.coreModelService.delete((Deleteable)reminder);
        this.coreModelService.remove((Identifiable)reminder);
    }

    @Test
    public void createDeleteReminderGroup() throws IOException {
        IUserGroup group = (IUserGroup)new IUserGroupBuilder(CoreModelServiceHolder.get(), "testGroup").buildAndSave();
        IReminder reminder = (IReminder)this.coreModelService.create(IReminder.class);
        reminder.setContact((IContact)this.patient);
        reminder.setCreator((IContact)this.mandator);
        reminder.setGroup(group);
        reminder.addResponsible((IContact)this.mandator);
        reminder.addResponsible((IContact)this.person);
        reminder.setSubject("test");
        this.coreModelService.save((Identifiable)reminder);
        reminder = this.coreModelService.load(reminder.getId(), IReminder.class).orElse(null);
        Assert.assertNotNull((Object)reminder);
        Assert.assertEquals((Object)group, (Object)reminder.getGroup());
        this.coreModelService.delete((Deleteable)reminder);
        this.coreModelService.remove((Identifiable)reminder);
    }

    @Test
    public void createQuery() throws IOException {
        IReminder reminder = (IReminder)this.coreModelService.create(IReminder.class);
        reminder.setContact((IContact)this.patient);
        reminder.setCreator((IContact)this.mandator);
        reminder.addResponsible((IContact)this.mandator);
        reminder.addResponsible((IContact)this.person);
        reminder.setSubject("test");
        this.coreModelService.save((Identifiable)reminder);
        IQuery query = this.coreModelService.getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
        Assert.assertEquals((long)1L, (long)query.execute().size());
        IReminder otherReminder = (IReminder)this.coreModelService.create(IReminder.class);
        otherReminder.setContact((IContact)this.patient);
        otherReminder.setCreator((IContact)this.mandator);
        otherReminder.addResponsible((IContact)this.person);
        otherReminder.setSubject("test other");
        this.coreModelService.save((Identifiable)otherReminder);
        IReminder allReminder = (IReminder)this.coreModelService.create(IReminder.class);
        allReminder.setContact((IContact)this.patient);
        allReminder.setCreator((IContact)this.person);
        allReminder.setResponsibleAll(true);
        allReminder.setSubject("test all");
        allReminder.setDue(LocalDate.now().minusDays(2L));
        this.coreModelService.save((Identifiable)allReminder);
        query = this.coreModelService.getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, this.coreModelService);
        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)this.mandator);
        query.exists(subQuery);
        Assert.assertEquals((long)1L, (long)query.execute().size());
        query = this.coreModelService.getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
        query.startGroup();
        subQuery = query.createSubQuery(IReminderResponsibleLink.class, this.coreModelService);
        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)this.mandator);
        query.exists(subQuery);
        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
        query.andJoinGroups();
        Assert.assertEquals((long)2L, (long)query.execute().size());
        query = this.coreModelService.getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, (Object)this.mandator);
        query.startGroup();
        subQuery = query.createSubQuery(IReminderResponsibleLink.class, this.coreModelService);
        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)this.mandator);
        query.exists(subQuery);
        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
        query.orJoinGroups();
        Assert.assertEquals((long)3L, (long)query.execute().size());
        query = this.coreModelService.getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
        query.startGroup();
        subQuery = query.createSubQuery(IReminderResponsibleLink.class, this.coreModelService);
        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)this.mandator);
        query.exists(subQuery);
        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
        query.andJoinGroups();
        Assert.assertEquals((long)1L, (long)query.execute().size());
        this.coreModelService.remove((Identifiable)reminder);
        this.coreModelService.remove((Identifiable)otherReminder);
        this.coreModelService.remove((Identifiable)allReminder);
    }
}

