/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalServiceTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createUserSetActiveInContext();
        super.createMandator();
        super.createPatient();
        super.createCoverage();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void create() {
        ICustomService service = (ICustomService)this.coreModelService.create(ICustomService.class);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)(service instanceof ICustomService));
        service.setText("test service");
        service.setCode("1234");
        service.setNetPrice(new Money(512));
        service.setPrice(new Money(1024));
        this.coreModelService.save((Identifiable)service);
        Optional loaded = this.coreModelService.load(service.getId(), ICustomService.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((service == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)service, loaded.get());
        Assert.assertEquals((Object)service.getCode(), (Object)((ICustomService)loaded.get()).getCode());
        Assert.assertEquals((Object)service.getText(), (Object)((ICustomService)loaded.get()).getText());
        Assert.assertEquals((Object)service.getNetPrice(), (Object)((ICustomService)loaded.get()).getNetPrice());
        Assert.assertEquals((Object)service.getPrice(), (Object)((ICustomService)loaded.get()).getPrice());
        this.coreModelService.remove((Identifiable)service);
    }

    @Test
    public void query() {
        ICustomService service = (ICustomService)this.coreModelService.create(ICustomService.class);
        service.setText("test service");
        service.setCode("1234");
        service.setNetPrice(new Money(12));
        service.setPrice(new Money(13));
        this.coreModelService.save((Identifiable)service);
        ICustomService service1 = (ICustomService)this.coreModelService.create(ICustomService.class);
        service1.setText("test service 1");
        service1.setCode("9876");
        service1.setNetPrice(new Money(24));
        service1.setPrice(new Money(25));
        this.coreModelService.save((Identifiable)service1);
        IQuery query = this.coreModelService.getQuery(ICustomService.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICODE_ELEMENT__CODE, IQuery.COMPARATOR.EQUALS, (Object)"1234");
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertEquals((Object)service, existing.get(0));
        this.coreModelService.remove((Identifiable)service);
        this.coreModelService.remove((Identifiable)service1);
    }

    @Test
    public void optifier() {
        ICustomService service = (ICustomService)this.coreModelService.create(ICustomService.class);
        service.setText("test service");
        service.setCode("1234");
        service.setNetPrice(new Money(12));
        service.setPrice(new Money(13));
        this.coreModelService.save((Identifiable)service);
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        Result result = service.getOptifier().add((IBillable)service, encounter, 1.5);
        Assert.assertTrue((boolean)result.isOK());
        Assert.assertFalse((boolean)encounter.getBilled().isEmpty());
        IBilled billed = (IBilled)encounter.getBilled().get(0);
        Assert.assertEquals((double)1.5, (double)billed.getAmount(), (double)0.01);
        Assert.assertEquals((Object)service.getPrice(), (Object)billed.getPrice());
        Assert.assertEquals((Object)service.getNetPrice(), (Object)billed.getNetPrice());
        Assert.assertEquals((Object)service.getText(), (Object)billed.getText());
        this.coreModelService.remove((Identifiable)billed);
        this.coreModelService.remove((Identifiable)encounter);
        this.coreModelService.remove((Identifiable)service);
    }
}

