/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mediorder.mail.task;

import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.MailTextTemplate;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mediorder.MediorderUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediorderMailIdentifiedRunnable
implements IIdentifiedRunnable {
    private IModelService coreModelService;
    private IContextService contextService;
    private ITextReplacementService textReplacementService;
    private IStockService stockService;
    private IStickerService stickerService;

    public MediorderMailIdentifiedRunnable(IModelService coreModelService, IContextService contextService, ITextReplacementService textReplacementService, IStockService stockService, IStickerService stickerser) {
        this.coreModelService = coreModelService;
        this.contextService = contextService;
        this.textReplacementService = textReplacementService;
        this.stockService = stockService;
        this.stickerService = stickerser;
    }

    public String getId() {
        return "mediorderMailSend";
    }

    public String getLocalizedDescription() {
        return "sends the patient an email to collect the ordered articles";
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        defaultRunContext.put("E-Mail Account", (Serializable)((Object)"missingRequired"));
        Optional template = MailTextTemplate.load((String)"Medikamentenbestellung abholbereit");
        defaultRunContext.put("E-Mail Template", (Serializable)((Object)template.map(ITextTemplate::getName).orElse("missingRequired")));
        return defaultRunContext;
    }

    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        Optional sticker = this.coreModelService.load("mediorderMailSent", ISticker.class);
        if (sticker.isEmpty()) {
            throw new TaskException(6, "no mediorderMailSend sticker found");
        }
        for (IStock stock : this.stockService.getAllPatientStock()) {
            IPatient patient = stock.getOwner().asIPatient();
            if (this.stickerService.hasSticker((Identifiable)patient, (ISticker)sticker.get()) || MediorderUtil.calculateStockState((IStock)stock) != 1) continue;
            if (this.sendMediorderMail(runContext.get("E-Mail Account").toString(), this.createMailMessage(patient)).isOK()) {
                this.stickerService.addSticker((ISticker)sticker.get(), (Identifiable)patient);
                continue;
            }
            throw new TaskException(6, "mediorder mail not send");
        }
        return null;
    }

    private MailMessage createMailMessage(IPatient patient) {
        Optional template = MailTextTemplate.load((String)"Medikamentenbestellung abholbereit");
        String subject = (String)((ITextTemplate)template.get()).getExtInfo((Object)"subject");
        IContext context = this.contextService.createNamedContext("mediorder_mail_context");
        context.setTyped((Object)patient);
        String preparedText = this.textReplacementService.performReplacement(context, ((ITextTemplate)template.get()).getTemplate());
        return new MailMessage().to(patient.getEmail()).subject(subject.isBlank() || subject == null ? ((ITextTemplate)template.get()).getName() : subject).text(preparedText);
    }

    private IStatus sendMediorderMail(String accountId, MailMessage message) {
        Optional taskDescriptor = TaskUtil.createSendMailTaskDescriptor((String)accountId, (MailMessage)message);
        if (taskDescriptor.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        try {
            ITask task = TaskUtil.executeTaskSync((ITaskDescriptor)((ITaskDescriptor)taskDescriptor.get()), (IProgressMonitor)new NullProgressMonitor());
            return task.isSucceeded() ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
        catch (TaskException e) {
            LoggerFactory.getLogger(TaskUtil.class).error("Error executing mail task", (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }
}

