/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.preference;

import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.ui.archive.ArchiveUtil;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.preference.CopyVirtLocalAccountAction;
import ch.elexis.core.mail.ui.preference.MailAccountComposite;
import ch.elexis.core.mail.ui.preference.RemoveAccountAction;
import ch.elexis.core.mail.ui.preference.SaveAccountAction;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.documents.composites.CategorySelectionEditComposite;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preference
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite parentComposite;
    private MailAccountComposite accountComposite;
    private ComboViewer accountsViewer;
    private Button testButton;
    private Button defaultBtn;
    private Button archiveButton;
    private CategorySelectionEditComposite archiveCategorySelection;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(2, false));
        this.accountsViewer = new ComboViewer(this.parentComposite);
        this.accountsViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.accountsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.accountsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.updateAccountsCombo();
        this.accountsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index = Preference.this.accountsViewer.getCombo().getSelectionIndex();
                if (index == 0) {
                    Preference.this.accountComposite.setAccount(new MailAccount());
                    Preference.this.testButton.setEnabled(true);
                    Preference.this.defaultBtn.setEnabled(false);
                    Preference.this.defaultBtn.setSelection(false);
                } else {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    String accountId = (String)selection.getFirstElement();
                    if (accountId != null) {
                        String defaultAccount = ConfigServiceHolder.get().get("account", null);
                        Preference.this.defaultBtn.setSelection(defaultAccount != null && accountId.equals(defaultAccount));
                        if (MailClientComponent.isVirtLocal(accountId)) {
                            Optional selectedAccount = MailClientComponent.getMailClient().getAccount(accountId);
                            if (selectedAccount.isPresent()) {
                                Preference.this.accountComposite.setAccount((MailAccount)selectedAccount.get());
                                Preference.this.testButton.setEnabled(true);
                                Preference.this.defaultBtn.setEnabled(true);
                            }
                        } else {
                            Optional selectedAccount = MailClientComponent.getMailClient().getAccount(accountId);
                            if (selectedAccount.isPresent()) {
                                Preference.this.accountComposite.setAccount((MailAccount)selectedAccount.get());
                                Preference.this.testButton.setEnabled(true);
                                Preference.this.defaultBtn.setEnabled(true);
                            }
                        }
                    }
                }
            }
        });
        ToolBar accountsTool = new ToolBar(this.parentComposite, 0);
        this.accountComposite = new MailAccountComposite(this.parentComposite, 0);
        this.accountComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.defaultBtn = new Button(this.parentComposite, 32);
        this.defaultBtn.setText("Als Standard E-Mail Konto verwenden");
        this.defaultBtn.addListener(13, e -> {
            IStructuredSelection selectedAccount = this.accountsViewer.getStructuredSelection();
            if (selectedAccount != null) {
                ConfigServiceHolder.get().set("account", (String)selectedAccount.getFirstElement());
            }
        });
        this.defaultBtn.setEnabled(false);
        new Label(this.parentComposite, 0);
        this.testButton = new Button(this.parentComposite, 8);
        this.testButton.setText("Test");
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MailClientComponent.getMailClient() != null && Preference.this.accountComposite.getAccount() != null) {
                    if (MailClientComponent.getMailClient().testAccount(Preference.this.accountComposite.getAccount())) {
                        MessageDialog.openInformation((Shell)Preference.this.getShell(), (String)"Test", (String)"Test erfolgreich.");
                    } else {
                        String message = MailClientComponent.getLastErrorMessage();
                        MessageDialog.openError((Shell)Preference.this.getShell(), (String)"Fehler", (String)message);
                    }
                }
            }
        });
        ToolBarManager accountsToolMgr = new ToolBarManager(accountsTool);
        accountsToolMgr.add((IAction)new CopyVirtLocalAccountAction(this.accountComposite, this));
        accountsToolMgr.add((IAction)new SaveAccountAction(this.accountComposite, this));
        accountsToolMgr.add((IAction)new RemoveAccountAction(this.accountComposite, this));
        accountsToolMgr.update(true);
        Label separator = new Label(this.parentComposite, 258);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.heightHint = 10;
        separator.setLayoutData((Object)gd);
        this.archiveButton = new Button(this.parentComposite, 32);
        this.archiveButton.setText("E-Mail Anh\u00e4nge archivieren");
        this.archiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.get().set(ArchiveUtil.PREF_MAIL_ARCHIVE_ENABLED, Preference.this.archiveButton.getSelection());
                Preference.this.archiveCategorySelection.setEnabled(Preference.this.archiveButton.getSelection());
            }
        });
        this.archiveButton.setSelection(ConfigServiceHolder.get().get(ArchiveUtil.PREF_MAIL_ARCHIVE_ENABLED, false));
        this.archiveButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label categoryLabel = new Label(this.parentComposite, 0);
        categoryLabel.setText("Archiv Kategorie");
        this.archiveCategorySelection = new CategorySelectionEditComposite(this.parentComposite, 0, "ch.elexis.data.store.omnivore", true);
        this.archiveCategorySelection.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.archiveCategorySelection.setEnabled(ConfigServiceHolder.get().get(ArchiveUtil.PREF_MAIL_ARCHIVE_ENABLED, false));
        this.archiveCategorySelection.addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ICategory category = Preference.this.archiveCategorySelection.getSelection();
                if (category != null) {
                    ConfigServiceHolder.get().set(ArchiveUtil.PREF_MAIL_ARCHIVE_DOCUMENT_CATEGORY, category.getName());
                } else {
                    ConfigServiceHolder.get().set(ArchiveUtil.PREF_MAIL_ARCHIVE_DOCUMENT_CATEGORY, null);
                }
            }
        });
        this.archiveCategorySelection.setCategoryByName(ConfigServiceHolder.get().get(ArchiveUtil.PREF_MAIL_ARCHIVE_DOCUMENT_CATEGORY, ArchiveUtil.DEFAULT_CATEGORY));
        return this.parentComposite;
    }

    public boolean performOk() {
        MailAccount account = this.accountComposite.getAccount();
        if (account != null) {
            if (MailClientComponent.isVirtLocal(account)) {
                MailClientComponent.getMailClient().saveAccountLocal(account);
            } else {
                MailClientComponent.getMailClient().saveAccount(account);
            }
        }
        return super.performOk();
    }

    protected void updateAccountsCombo() {
        if (MailClientComponent.getMailClient() != null) {
            MailAccount account;
            this.accountsViewer.getControl().setEnabled(true);
            List accountsInput = MailClientComponent.getMailClient().getAccountsLocal();
            accountsInput.addAll(MailClientComponent.getMailClient().getAccounts());
            accountsInput.add(0, "Neu erstellen");
            this.accountsViewer.setInput((Object)accountsInput);
            if (this.accountComposite != null && (account = this.accountComposite.getAccount()) != null) {
                this.accountsViewer.setSelection((ISelection)new StructuredSelection((Object)account.getId()));
            }
        } else {
            this.accountsViewer.getControl().setEnabled(false);
            this.testButton.setEnabled(false);
        }
    }
}

