/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.preference;

import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.preference.MailAccountComposite;
import ch.elexis.core.mail.ui.preference.Preference;
import ch.elexis.core.ui.icons.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public class CopyVirtLocalAccountAction
extends Action {
    private MailAccountComposite accountComposite;
    private Preference preference;

    public CopyVirtLocalAccountAction(MailAccountComposite accountComposite, Preference preference) {
        this.accountComposite = accountComposite;
        this.preference = preference;
    }

    public void run() {
        MailAccount account = this.accountComposite.getAccount();
        if (account != null) {
            if (!MailClientComponent.getMailClient().getAccountsLocal().contains(MailClientComponent.getVirtLocalId(account))) {
                MailAccount localAccount = account.copy();
                localAccount.setId(MailClientComponent.getVirtLocalId(account));
                MailClientComponent.getMailClient().saveAccountLocal(localAccount);
                this.preference.updateAccountsCombo();
            } else {
                MailAccount localAccount = MailClientComponent.getMailClient().getAccount(MailClientComponent.getVirtLocalId(account)).orElse(null);
                this.accountComposite.setAccount(localAccount);
                this.preference.updateAccountsCombo();
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return Images.IMG_COPY.getImageDescriptor();
    }

    public String getToolTipText() {
        return "Kopie als lokale virtuelle Konfig";
    }

    public boolean isEnabled() {
        return MailClientComponent.getMailClient() != null;
    }
}

