/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mail.ui.dialogs.SendMailDialog;
import ch.elexis.core.mail.ui.handlers.SendMailTaskWithProgress;
import ch.elexis.core.mail.ui.handlers.TaskServiceHolder;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.TaskState;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SendMailTaskHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String taskId = event.getParameter("ch.elexis.core.mail.ui.sendMailTaskDescriptorId");
        Optional taskDescriptor = TaskUtil.getTaskDescriptor((String)taskId);
        if (taskDescriptor.isPresent()) {
            MailMessage message = MailMessage.fromJson((Serializable)((Serializable)((ITaskDescriptor)taskDescriptor.get()).getRunContext().get("message")));
            String accountId = (String)((ITaskDescriptor)taskDescriptor.get()).getRunContext().get("accountId");
            if (message != null) {
                SendMailDialog sendMailDialog = new SendMailDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                sendMailDialog.setMailMessage(message);
                sendMailDialog.setAccountId(accountId);
                sendMailDialog.disableOutbox();
                Optional execution = TaskServiceHolder.get().findLatestExecution((ITaskDescriptor)taskDescriptor.get());
                if (execution.isPresent()) {
                    sendMailDialog.sent(((ITask)execution.get()).getFinishedAt());
                }
                if (sendMailDialog.open() == 0) {
                    MailMessage sendMessage = new MailMessage().to(sendMailDialog.getTo()).cc(sendMailDialog.getCc()).subject(sendMailDialog.getSubject()).text(sendMailDialog.getText());
                    sendMessage.setAttachments(sendMailDialog.getAttachmentsString());
                    sendMessage.setDocuments(sendMailDialog.getDocumentsString());
                    Map runContext = ((ITaskDescriptor)taskDescriptor.get()).getRunContext();
                    runContext.put("accountId", sendMailDialog.getAccount().getId());
                    runContext.put("message", sendMessage);
                    ((ITaskDescriptor)taskDescriptor.get()).setRunContext(runContext);
                    ITaskDescriptor descriptor = TaskUtil.configureTaskDescriptor((ITaskDescriptor)((ITaskDescriptor)taskDescriptor.get()), (String)sendMailDialog.getAccount().getId(), (MailMessage)sendMessage);
                    ITask task = new SendMailTaskWithProgress().execute(HandlerUtil.getActiveShell((ExecutionEvent)event), descriptor, message);
                    return task.getState() == TaskState.COMPLETED;
                }
            }
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Der mail Task konnte nicht ge\u00f6ffnet werden.");
        }
        return Boolean.FALSE;
    }
}

