/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextTemplateDialog
extends Dialog {
    private IMandator mandator;
    private String name;
    private List<Object> list;

    public TextTemplateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        final Text nameTxt = new Text(container, 2048);
        nameTxt.setMessage("Vorlagenname");
        nameTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        nameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextTemplateDialog.this.name = nameTxt.getText();
            }
        });
        ComboViewer comboViewer = new ComboViewer(container, 2048);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IMandator) {
                    return ((IMandator)element).getLabel();
                }
                return super.getText(element);
            }
        });
        List<String> content = new ArrayList<String>();
        content.add("Alle Mandanten");
        IQuery query = CoreModelServiceHolder.get().getQuery(IMandator.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)Boolean.TRUE);
        content.addAll(query.execute());
        if (ContextServiceHolder.get().getActiveUser().isPresent() && !((IUser)ContextServiceHolder.get().getActiveUser().get()).isAdministrator()) {
            content = content.stream().filter(o -> this.isAllOrCurrentMandator(o)).collect(Collectors.toList());
        }
        comboViewer.setInput(content);
        comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection() != null && !event.getStructuredSelection().isEmpty()) {
                    TextTemplateDialog.this.mandator = event.getStructuredSelection().getFirstElement() instanceof IMandator ? (IMandator)event.getStructuredSelection().getFirstElement() : null;
                }
            }
        });
        return container;
    }

    private boolean isAllOrCurrentMandator(Object o) {
        if (o instanceof IMandator && ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return ((IMandator)ContextServiceHolder.get().getActiveMandator().get()).equals(o);
        }
        return true;
    }

    public IMandator getMandator() {
        return this.mandator;
    }

    public String getName() {
        return this.name;
    }
}

