/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class MailAddressContentProposalProvider
implements IContentProposalProvider {
    public IContentProposal[] getProposals(String contents, int position) {
        IPatient activePatient;
        ArrayList<IdentifiableContentProposal> ret = new ArrayList<IdentifiableContentProposal>();
        HashSet<IContact> contacts = new HashSet<IContact>();
        String addressString = null;
        if (contents != null && !contents.isEmpty()) {
            addressString = this.getContentAddress(contents);
        }
        if ((activePatient = (IPatient)ContextServiceHolder.get().getActivePatient().orElse(null)) != null) {
            IQuery lastQuery = CoreModelServiceHolder.get().getQuery(IDocumentLetter.class);
            lastQuery.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)activePatient);
            lastQuery.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT_LETTER__RECIPIENT, IQuery.COMPARATOR.NOT_EQUALS, null);
            lastQuery.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.DESC);
            for (IDocumentLetter document : lastQuery.execute()) {
                if (document.getRecipient() == null || !StringUtils.isNotBlank((CharSequence)document.getRecipient().getEmail())) continue;
                String email = document.getRecipient().getEmail();
                if (addressString != null && addressString.length() > 1 && !email.contains(addressString) && !document.getRecipient().getDescription1().contains(addressString) && !document.getRecipient().getDescription2().contains(addressString) || contacts.contains(document.getRecipient())) continue;
                contacts.add(document.getRecipient());
                ret.add(new IdentifiableContentProposal(email + " - " + document.getRecipient().getLabel(), (Object)document.getRecipient()));
            }
        }
        if (addressString != null && addressString.length() > 1) {
            IQuery query = CoreModelServiceHolder.get().getQuery(IContact.class);
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__EMAIL, IQuery.COMPARATOR.LIKE, (Object)("%" + addressString + "%"));
            query.startGroup();
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)("%" + addressString + "%"));
            query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.LIKE, (Object)("%" + addressString + "%"));
            query.orJoinGroups();
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__EMAIL, IQuery.COMPARATOR.NOT_EQUALS, null);
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__EMAIL, IQuery.COMPARATOR.NOT_EQUALS, (Object)"");
            for (IContact contact : query.execute()) {
                if (contacts.contains(contact)) continue;
                ret.add(new IdentifiableContentProposal(contact.getEmail() + " - " + contact.getLabel(), (Object)contact));
            }
        }
        return ret.toArray(new IContentProposal[ret.size()]);
    }

    private String getContentAddress(String contents) {
        int index = MailAddressContentProposalProvider.getLastAddressIndex(contents);
        if (index == 0) {
            return contents;
        }
        return contents.substring(index + 1).trim();
    }

    public static int getLastAddressIndex(String contents) {
        int index = contents.lastIndexOf(",");
        if (index == -1) {
            return 0;
        }
        return index;
    }
}

