/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.liquibase;

import ch.elexis.core.jpa.entitymanager.ui.IDatabaseUpdateUi;
import ch.elexis.core.l10n.Messages;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseDBUpdater {
    private static Logger logger = LoggerFactory.getLogger(LiquibaseDBUpdater.class);
    private String changelogXmlUrl;
    private DataSource dataSource;
    private IDatabaseUpdateUi updateProgress;

    public LiquibaseDBUpdater(DataSource dataSource, IDatabaseUpdateUi updateProgress) {
        this.dataSource = dataSource;
        this.changelogXmlUrl = "/db/elexisdb_master_update.xml";
        this.updateProgress = updateProgress;
    }

    public boolean update() {
        block19: {
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
            Liquibase liquibase = null;
            Connection connection = null;
            try {
                try {
                    connection = this.dataSource.getConnection();
                    JdbcConnection database = new JdbcConnection(connection);
                    Database targetDb = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)database);
                    liquibase = new Liquibase(this.changelogXmlUrl, (ResourceAccessor)resourceAccessor, targetDb);
                    if (this.updateProgress != null) {
                        liquibase.setChangeExecListener((ChangeExecListener)new AbstractChangeExecListener(){

                            public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
                                LiquibaseDBUpdater.this.updateProgress.setMessage(Messages.LiquibaseDBUpdater_Update_execute + changeSet.getDescription());
                            }
                        });
                    }
                    logger.info("Updating database [" + String.valueOf(connection) + "] with liquibase");
                    try {
                        liquibase.update("");
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof ValidationFailedException || e instanceof ValidationFailedException) {
                            logger.info("Validation failed clear checksums and retry");
                            liquibase.clearCheckSums();
                            liquibase.changeLogSync("");
                            break block19;
                        }
                        logger.error("Exception performing DB init", (Throwable)e);
                    }
                }
                catch (SQLException | LiquibaseException e) {
                    logger.warn("Exception on DB update.", e);
                    try {
                        if (liquibase != null) {
                            liquibase.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            }
            finally {
                try {
                    if (liquibase != null) {
                        liquibase.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

