/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.StockEntry;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.List;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="STOCK")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
public class Stock
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column(nullable=false, unique=true)
    int priority;
    @Column(length=7, unique=true)
    String code;
    @Column(length=255)
    String description;
    @Column(length=255)
    String location;
    @OneToOne
    @JoinColumn(name="OWNER")
    Kontakt owner;
    @OneToOne
    @JoinColumn(name="RESPONSIBLE", insertable=false)
    Kontakt responsible;
    @Column(name="driver_uuid", length=64)
    String driverUuid;
    @Lob
    @Column(name="driver_config")
    String driverConfig;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="stock", cascade={CascadeType.REMOVE})
    private List<StockEntry> entries;
    static final long serialVersionUID = -3169990997285232052L;

    public Stock() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    @Override
    public String toString() {
        return super.toString() + " code=[" + this.getCode() + "] driverUuid=[" + this.getDriverUuid() + "] driverConfig=[" + this.getDriverConfig() + "]";
    }

    public String getCode() {
        return this._persistence_get_code();
    }

    public void setCode(String code) {
        this._persistence_set_code(code);
    }

    public int getPriority() {
        return this._persistence_get_priority();
    }

    public void setPriority(int priority) {
        this._persistence_set_priority(priority);
    }

    public Kontakt getOwner() {
        return this._persistence_get_owner();
    }

    public void setOwner(Kontakt owner) {
        this._persistence_set_owner(owner);
    }

    public Kontakt getResponsible() {
        return this._persistence_get_responsible();
    }

    public void setResponsible(Kontakt responsible) {
        this._persistence_set_responsible(responsible);
    }

    public String getLocation() {
        return this._persistence_get_location();
    }

    public void setLocation(String location) {
        this._persistence_set_location(location);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getDriverUuid() {
        return this._persistence_get_driverUuid();
    }

    public void setDriverUuid(String driverUuid) {
        this._persistence_set_driverUuid(driverUuid);
    }

    public String getDriverConfig() {
        return this._persistence_get_driverConfig();
    }

    public void setDriverConfig(String driverConfig) {
        this._persistence_set_driverConfig(driverConfig);
    }

    public List<StockEntry> getEntries() {
        return this._persistence_get_entries();
    }

    public void setEntries(List<StockEntry> entries) {
        this._persistence_set_entries(entries);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Stock(persistenceObject);
    }

    public Stock(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "owner") {
            return this.owner;
        }
        if (string == "driverConfig") {
            return this.driverConfig;
        }
        if (string == "entries") {
            return this.entries;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "code") {
            return this.code;
        }
        if (string == "responsible") {
            return this.responsible;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "location") {
            return this.location;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "driverUuid") {
            return this.driverUuid;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "owner") {
            this.owner = (Kontakt)object;
            return;
        }
        if (string == "driverConfig") {
            this.driverConfig = (String)object;
            return;
        }
        if (string == "entries") {
            this.entries = (List)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "code") {
            this.code = (String)object;
            return;
        }
        if (string == "responsible") {
            this.responsible = (Kontakt)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "location") {
            this.location = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "priority") {
            this.priority = (Integer)object;
            return;
        }
        if (string == "driverUuid") {
            this.driverUuid = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Kontakt _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        return this.owner;
    }

    public void _persistence_set_owner(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_propertyChange("owner", this.owner, kontakt);
        this.owner = kontakt;
    }

    public String _persistence_get_driverConfig() {
        this._persistence_checkFetched("driverConfig");
        return this.driverConfig;
    }

    public void _persistence_set_driverConfig(String string) {
        this._persistence_checkFetchedForSet("driverConfig");
        this._persistence_propertyChange("driverConfig", this.driverConfig, string);
        this.driverConfig = string;
    }

    public List _persistence_get_entries() {
        this._persistence_checkFetched("entries");
        return this.entries;
    }

    public void _persistence_set_entries(List list) {
        this._persistence_checkFetchedForSet("entries");
        this._persistence_propertyChange("entries", this.entries, list);
        this.entries = list;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_code() {
        this._persistence_checkFetched("code");
        return this.code;
    }

    public void _persistence_set_code(String string) {
        this._persistence_checkFetchedForSet("code");
        this._persistence_propertyChange("code", this.code, string);
        this.code = string;
    }

    public Kontakt _persistence_get_responsible() {
        this._persistence_checkFetched("responsible");
        return this.responsible;
    }

    public void _persistence_set_responsible(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("responsible");
        this._persistence_propertyChange("responsible", this.responsible, kontakt);
        this.responsible = kontakt;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public String _persistence_get_location() {
        this._persistence_checkFetched("location");
        return this.location;
    }

    public void _persistence_set_location(String string) {
        this._persistence_checkFetchedForSet("location");
        this._persistence_propertyChange("location", this.location, string);
        this.location = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public int _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(int n) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", new Integer(this.priority), new Integer(n));
        this.priority = n;
    }

    public String _persistence_get_driverUuid() {
        this._persistence_checkFetched("driverUuid");
        return this.driverUuid;
    }

    public void _persistence_set_driverUuid(String string) {
        this._persistence_checkFetchedForSet("driverUuid");
        this._persistence_propertyChange("driverUuid", this.driverUuid, string);
        this.driverUuid = string;
    }
}

