/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.LabMapping;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.converter.LabItemTypConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.types.LabItemTyp;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="laboritems")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
@NamedQueries(value={@NamedQuery(name="LabItem.code.name", query="SELECT li FROM LabItem li WHERE li.deleted = false AND li.code = :code AND li.name = :name"), @NamedQuery(name="LabItem.code.name.typ", query="SELECT li FROM LabItem li WHERE li.deleted = false AND li.code = :code AND li.name = :name AND li.typ = :typ")})
public class LabItem
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column(name="kuerzel", length=80)
    private String code;
    @Column(name="titel", length=80)
    private String name;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="laborID")
    private Kontakt labor;
    @Column(name="RefMann", length=256)
    private String referenceMale;
    @Column(name="RefFrauOrTx", length=256)
    private String referenceFemale;
    @Column(name="einheit", length=20)
    private String unit;
    @Column(name="typ", length=1)
    @Convert(converter=LabItemTypConverter.class)
    private LabItemTyp typ;
    @Column(name="Gruppe", length=25)
    private String group;
    @Column(name="prio", length=3)
    private String priority;
    @Column(length=128)
    private String billingCode;
    @Column(length=100)
    private String export;
    @Column(length=128)
    private String loinccode;
    @Convert(converter=BooleanCharacterConverterSafe.class)
    private boolean visible;
    @Convert(converter=IntegerStringConverter.class)
    private int digits;
    @Column(length=255)
    private String formula;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="labItem")
    private List<LabMapping> mappings;
    static final long serialVersionUID = -2937341747167809890L;
    @Transient
    protected WeavedAttributeValueHolderInterface _persistence_labor_vh;

    public LabItem() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
        this.visible = true;
    }

    @java.beans.Transient
    public String getVariableName() {
        String group = this.getGroup();
        if (group != null && group.contains(" ")) {
            String[] g = group.split(" ", 2);
            String prio = this.getPriority();
            String num = prio != null ? prio.trim() : "9999";
            return g[0] + "_" + num;
        }
        return "ERROR";
    }

    public String getCode() {
        return this._persistence_get_code();
    }

    public void setCode(String code) {
        this._persistence_set_code(code);
    }

    public Kontakt getLabor() {
        return this._persistence_get_labor();
    }

    public void setLabor(Kontakt labor) {
        this._persistence_set_labor(labor);
    }

    public String getReferenceMale() {
        return this._persistence_get_referenceMale();
    }

    public void setReferenceMale(String referenceMale) {
        this._persistence_set_referenceMale(referenceMale);
    }

    public String getReferenceFemale() {
        return this._persistence_get_referenceFemale();
    }

    public void setReferenceFemale(String referenceFemale) {
        this._persistence_set_referenceFemale(referenceFemale);
    }

    public String getUnit() {
        return this._persistence_get_unit();
    }

    public void setUnit(String unit) {
        this._persistence_set_unit(unit);
    }

    public LabItemTyp getTyp() {
        return this._persistence_get_typ();
    }

    public void setTyp(LabItemTyp type) {
        this._persistence_set_typ(type);
    }

    public String getGroup() {
        return this._persistence_get_group();
    }

    public void setGroup(String group) {
        this._persistence_set_group(group);
    }

    public String getBillingCode() {
        return this._persistence_get_billingCode();
    }

    public void setBillingCode(String billingCode) {
        this._persistence_set_billingCode(billingCode);
    }

    public String getExport() {
        return this._persistence_get_export();
    }

    public void setExport(String export) {
        this._persistence_set_export(export);
    }

    public String getLoinccode() {
        return this._persistence_get_loinccode();
    }

    public void setLoinccode(String loinccode) {
        this._persistence_set_loinccode(loinccode);
    }

    public boolean isVisible() {
        return this._persistence_get_visible();
    }

    public void setVisible(boolean visible) {
        this._persistence_set_visible(visible);
    }

    public String getFormula() {
        return this._persistence_get_formula();
    }

    public void setFormula(String formula) {
        this._persistence_set_formula(formula);
    }

    public int getDigits() {
        return this._persistence_get_digits();
    }

    public void setDigits(int digits) {
        this._persistence_set_digits(digits);
    }

    public String getPriority() {
        return this._persistence_get_priority();
    }

    public void setPriority(String priority) {
        this._persistence_set_priority(priority);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    public List<LabMapping> getMappings() {
        return this._persistence_get_mappings();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_labor_vh != null) {
            this._persistence_labor_vh = (WeavedAttributeValueHolderInterface)this._persistence_labor_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new LabItem(persistenceObject);
    }

    public LabItem(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "code") {
            return this.code;
        }
        if (string == "visible") {
            return this.visible;
        }
        if (string == "typ") {
            return this.typ;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "loinccode") {
            return this.loinccode;
        }
        if (string == "referenceFemale") {
            return this.referenceFemale;
        }
        if (string == "labor") {
            return this.labor;
        }
        if (string == "billingCode") {
            return this.billingCode;
        }
        if (string == "referenceMale") {
            return this.referenceMale;
        }
        if (string == "unit") {
            return this.unit;
        }
        if (string == "mappings") {
            return this.mappings;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "formula") {
            return this.formula;
        }
        if (string == "digits") {
            return this.digits;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "export") {
            return this.export;
        }
        if (string == "group") {
            return this.group;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "code") {
            this.code = (String)object;
            return;
        }
        if (string == "visible") {
            this.visible = (Boolean)object;
            return;
        }
        if (string == "typ") {
            this.typ = (LabItemTyp)object;
            return;
        }
        if (string == "priority") {
            this.priority = (String)object;
            return;
        }
        if (string == "loinccode") {
            this.loinccode = (String)object;
            return;
        }
        if (string == "referenceFemale") {
            this.referenceFemale = (String)object;
            return;
        }
        if (string == "labor") {
            this.labor = (Kontakt)object;
            return;
        }
        if (string == "billingCode") {
            this.billingCode = (String)object;
            return;
        }
        if (string == "referenceMale") {
            this.referenceMale = (String)object;
            return;
        }
        if (string == "unit") {
            this.unit = (String)object;
            return;
        }
        if (string == "mappings") {
            this.mappings = (List)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "formula") {
            this.formula = (String)object;
            return;
        }
        if (string == "digits") {
            this.digits = (Integer)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "export") {
            this.export = (String)object;
            return;
        }
        if (string == "group") {
            this.group = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_code() {
        this._persistence_checkFetched("code");
        return this.code;
    }

    public void _persistence_set_code(String string) {
        this._persistence_checkFetchedForSet("code");
        this._persistence_propertyChange("code", this.code, string);
        this.code = string;
    }

    public boolean _persistence_get_visible() {
        this._persistence_checkFetched("visible");
        return this.visible;
    }

    public void _persistence_set_visible(boolean bl) {
        this._persistence_checkFetchedForSet("visible");
        this._persistence_propertyChange("visible", new Boolean(this.visible), new Boolean(bl));
        this.visible = bl;
    }

    public LabItemTyp _persistence_get_typ() {
        this._persistence_checkFetched("typ");
        return this.typ;
    }

    public void _persistence_set_typ(LabItemTyp labItemTyp) {
        this._persistence_checkFetchedForSet("typ");
        this._persistence_propertyChange("typ", this.typ, labItemTyp);
        this.typ = labItemTyp;
    }

    public String _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(String string) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", this.priority, string);
        this.priority = string;
    }

    public String _persistence_get_loinccode() {
        this._persistence_checkFetched("loinccode");
        return this.loinccode;
    }

    public void _persistence_set_loinccode(String string) {
        this._persistence_checkFetchedForSet("loinccode");
        this._persistence_propertyChange("loinccode", this.loinccode, string);
        this.loinccode = string;
    }

    public String _persistence_get_referenceFemale() {
        this._persistence_checkFetched("referenceFemale");
        return this.referenceFemale;
    }

    public void _persistence_set_referenceFemale(String string) {
        this._persistence_checkFetchedForSet("referenceFemale");
        this._persistence_propertyChange("referenceFemale", this.referenceFemale, string);
        this.referenceFemale = string;
    }

    protected void _persistence_initialize_labor_vh() {
        if (this._persistence_labor_vh == null) {
            this._persistence_labor_vh = new ValueHolder((Object)this.labor);
            this._persistence_labor_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_labor_vh() {
        Kontakt kontakt;
        this._persistence_initialize_labor_vh();
        if ((this._persistence_labor_vh.isCoordinatedWithProperty() || this._persistence_labor_vh.isNewlyWeavedValueHolder()) && (kontakt = this._persistence_get_labor()) != this._persistence_labor_vh.getValue()) {
            this._persistence_set_labor(kontakt);
        }
        return this._persistence_labor_vh;
    }

    public void _persistence_set_labor_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_labor_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Kontakt kontakt = this._persistence_get_labor();
            if (kontakt != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_labor((Kontakt)object);
            }
        } else {
            this.labor = null;
        }
    }

    public Kontakt _persistence_get_labor() {
        this._persistence_checkFetched("labor");
        this._persistence_initialize_labor_vh();
        this.labor = (Kontakt)this._persistence_labor_vh.getValue();
        return this.labor;
    }

    public void _persistence_set_labor(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("labor");
        this._persistence_initialize_labor_vh();
        this.labor = (Kontakt)this._persistence_labor_vh.getValue();
        this._persistence_propertyChange("labor", this.labor, kontakt);
        this.labor = kontakt;
        this._persistence_labor_vh.setValue((Object)kontakt);
    }

    public String _persistence_get_billingCode() {
        this._persistence_checkFetched("billingCode");
        return this.billingCode;
    }

    public void _persistence_set_billingCode(String string) {
        this._persistence_checkFetchedForSet("billingCode");
        this._persistence_propertyChange("billingCode", this.billingCode, string);
        this.billingCode = string;
    }

    public String _persistence_get_referenceMale() {
        this._persistence_checkFetched("referenceMale");
        return this.referenceMale;
    }

    public void _persistence_set_referenceMale(String string) {
        this._persistence_checkFetchedForSet("referenceMale");
        this._persistence_propertyChange("referenceMale", this.referenceMale, string);
        this.referenceMale = string;
    }

    public String _persistence_get_unit() {
        this._persistence_checkFetched("unit");
        return this.unit;
    }

    public void _persistence_set_unit(String string) {
        this._persistence_checkFetchedForSet("unit");
        this._persistence_propertyChange("unit", this.unit, string);
        this.unit = string;
    }

    public List _persistence_get_mappings() {
        this._persistence_checkFetched("mappings");
        return this.mappings;
    }

    public void _persistence_set_mappings(List list) {
        this._persistence_checkFetchedForSet("mappings");
        this._persistence_propertyChange("mappings", this.mappings, list);
        this.mappings = list;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_formula() {
        this._persistence_checkFetched("formula");
        return this.formula;
    }

    public void _persistence_set_formula(String string) {
        this._persistence_checkFetchedForSet("formula");
        this._persistence_propertyChange("formula", this.formula, string);
        this.formula = string;
    }

    public int _persistence_get_digits() {
        this._persistence_checkFetched("digits");
        return this.digits;
    }

    public void _persistence_set_digits(int n) {
        this._persistence_checkFetchedForSet("digits");
        this._persistence_propertyChange("digits", new Integer(this.digits), new Integer(n));
        this.digits = n;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_export() {
        this._persistence_checkFetched("export");
        return this.export;
    }

    public void _persistence_set_export(String string) {
        this._persistence_checkFetchedForSet("export");
        this._persistence_propertyChange("export", this.export, string);
        this.export = string;
    }

    public String _persistence_get_group() {
        this._persistence_checkFetched("group");
        return this.group;
    }

    public void _persistence_set_group(String string) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_propertyChange("group", this.group, string);
        this.group = string;
    }
}

