/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.tasks.internal;

import ch.elexis.core.importer.div.importers.DefaultPersistenceHandler;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.importers.multifile.MultiFileParser;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.elexis.core.importer.div.tasks.internal.HL7ImportStrategyFactory;
import ch.elexis.core.importer.div.tasks.internal.HL7ImporterLabContactResolver;
import ch.elexis.core.importer.div.tasks.internal.HL7ImporterPatientResolver;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.SerializableBoolean;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.rgw.tools.Result;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;

public class HL7ImporterIIdentifiedRunnable
implements IIdentifiedRunnable {
    public static final String RUNNABLE_ID = "hl7importer";
    public static final String DESCRIPTION = "Import a single hl7 file from a given url";
    public static final String RCP_STRING_IMPORTER_LABNAME = "labName";
    public static final String RCP_BOOLEAN_CREATE_PATIENT_IF_NOT_EXISTS = "createPatientIfNotExists";
    public static final String RCP_BOOLEAN_CREATE_LABORATORY_IF_NOT_EXISTS = "createLaboratoryIfNotExists";
    public static final String RCP_BOOLEAN_OVERWRITE_EXISTING_RESULTS = "overwriteExistingResults";
    public static final String RCP_BOOLEAN_IMPORT_ENCAPSULATED_DATA = "importEncapsulatedData";
    public static final String RCP_BOOLEAN_MOVE_FILE_AFTER_IMPORT = "moveFile";
    private ILabImportUtil labimportUtil;
    private IModelService coreModelService;
    private IVirtualFilesystemService vfsService;

    public HL7ImporterIIdentifiedRunnable(IModelService coreModelService, ILabImportUtil labimportUtil, IVirtualFilesystemService vfsService) {
        this.coreModelService = coreModelService;
        this.labimportUtil = labimportUtil;
        this.vfsService = vfsService;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return DESCRIPTION;
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        defaultRunContext.put("url", (Serializable)((Object)"missingRequired"));
        defaultRunContext.put(RCP_BOOLEAN_CREATE_PATIENT_IF_NOT_EXISTS, Boolean.FALSE);
        defaultRunContext.put(RCP_BOOLEAN_CREATE_LABORATORY_IF_NOT_EXISTS, Boolean.TRUE);
        defaultRunContext.put(RCP_BOOLEAN_MOVE_FILE_AFTER_IMPORT, Boolean.TRUE);
        defaultRunContext.put(RCP_BOOLEAN_OVERWRITE_EXISTING_RESULTS, Boolean.TRUE);
        defaultRunContext.put(RCP_BOOLEAN_IMPORT_ENCAPSULATED_DATA, Boolean.TRUE);
        defaultRunContext.put(RCP_STRING_IMPORTER_LABNAME, (Serializable)((Object)"Eigenlabor"));
        return defaultRunContext;
    }

    public Map<String, Serializable> run(Map<String, Serializable> context, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        boolean bCreateLaboratoryIfNotExists = SerializableBoolean.valueOf(context, (String)RCP_BOOLEAN_CREATE_LABORATORY_IF_NOT_EXISTS);
        boolean bMoveFile = SerializableBoolean.valueOf(context, (String)RCP_BOOLEAN_MOVE_FILE_AFTER_IMPORT);
        boolean importEncData = SerializableBoolean.valueOf(context, (String)RCP_BOOLEAN_IMPORT_ENCAPSULATED_DATA);
        boolean overwriteExistingResults = SerializableBoolean.valueOf(context, (String)RCP_BOOLEAN_OVERWRITE_EXISTING_RESULTS);
        String urlString = (String)((Object)context.get("url"));
        String labName = (String)((Object)context.get(RCP_STRING_IMPORTER_LABNAME));
        MyImportHandler myImportHandler = new MyImportHandler(logger, overwriteExistingResults);
        HL7ImporterLabContactResolver labContactResolver = new HL7ImporterLabContactResolver(this.coreModelService, this.labimportUtil, logger, bCreateLaboratoryIfNotExists);
        IFileImportStrategyFactory importStrategyFactory = new HL7ImportStrategyFactory(logger, myImportHandler).setMoveAfterImport(bMoveFile).setLabContactResolver(labContactResolver);
        MultiFileParser multiFileParser = new MultiFileParser(labName);
        HL7Parser hl7Parser = new HL7Parser(labName, new HL7ImporterPatientResolver(this.coreModelService, logger), this.labimportUtil, myImportHandler, labContactResolver, importEncData);
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = this.vfsService.of(urlString);
            Result<Object> result = multiFileParser.importFromHandle(fileHandle, importStrategyFactory, hl7Parser, new DefaultPersistenceHandler());
            HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
            Result.msg fileUrl = result.removeMsgEntry("url", 779);
            if (fileUrl != null) {
                resultMap.put("url", (Serializable)((Object)((String)fileUrl.getObject())));
            }
            if (!result.isOK()) {
                resultMap.put("markerWarn", null);
            }
            resultMap.put("resultData", (Serializable)((Object)result.toString()));
            return resultMap;
        }
        catch (IOException e) {
            throw new TaskException(6, (Throwable)e);
        }
    }

    private class MyImportHandler
    extends ImportHandler {
        private final boolean overwriteExistingResults;
        private final Logger logger;

        public MyImportHandler(Logger logger, boolean overwriteExistingResults) {
            this.logger = logger;
            this.overwriteExistingResults = overwriteExistingResults;
        }

        @Override
        public ImportHandler.OverwriteState askOverwrite(IPatient patient, ILabResult oldResult, TransientLabResult newResult) {
            if (this.overwriteExistingResults) {
                this.logger.warn("Overwriting labResult [{}] old value [{}] new value [{}]", new Object[]{patient, oldResult, newResult});
                return ImportHandler.OverwriteState.OVERWRITE;
            }
            return ImportHandler.OverwriteState.IGNORE;
        }
    }
}

