/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.util;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.rgw.tools.VersionedResource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiConsultationHelper {
    private static final Logger logger = LoggerFactory.getLogger(KiConsultationHelper.class);

    public static boolean attachToEncounter(String orderNumber, String text) {
        Optional encounterOpt;
        block5: {
            block4: {
                try {
                    if (!StringUtils.isBlank((CharSequence)orderNumber)) break block4;
                    logger.warn("KI Consultation: Keine OrderNumber vorhanden");
                    return false;
                }
                catch (Exception e) {
                    logger.error("Fehler beim Speichern der KI-Konsultation", (Throwable)e);
                    return false;
                }
            }
            encounterOpt = CoreModelServiceHolder.get().load(orderNumber.trim(), IEncounter.class);
            if (!encounterOpt.isEmpty()) break block5;
            logger.warn("KI Consultation: Konsultation mit ID {} nicht gefunden", (Object)orderNumber);
            return false;
        }
        IEncounter kons = (IEncounter)encounterOpt.get();
        VersionedResource vr = kons.getVersionedEntry();
        Samdas samdas = vr != null && vr.getHead() != null ? new Samdas(vr.getHead()) : new Samdas();
        Samdas.Record record = samdas.getRecord();
        String oldText = StringUtils.defaultString((String)record.getText());
        String newBlock = "\n\n=== HL7 KI Import " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + " ===\n" + text.trim();
        record.setText(oldText + newBlock);
        EncounterServiceHolder.get().updateVersionedEntry(kons, samdas.toString(), "HL7 KI Import");
        logger.info("KI Consultation in Kons-ID {} importiert ({} Zeichen)", (Object)orderNumber, (Object)text.length());
        return true;
    }
}

