/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.internal;

import ch.elexis.core.findings.util.internal.FindingsFormat;
import ch.elexis.core.findings.util.internal.JsonStructuralFeature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FindingsFormat40
extends FindingsFormat {
    public FindingsFormat40() {
        HashMap<String, JsonStructuralFeature> conditionFields = new HashMap<String, JsonStructuralFeature>();
        conditionFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("category", new JsonStructuralFeature("category", JsonStructuralFeature.Type.ARRAY));
        conditionFields.put("code", new JsonStructuralFeature("code", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("recordedDate", new JsonStructuralFeature("recordedDate", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("clinicalStatus", new JsonStructuralFeature("clinicalStatus", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("Condition", conditionFields);
        HashMap<String, JsonStructuralFeature> encounterFields = new HashMap<String, JsonStructuralFeature>();
        encounterFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        encounterFields.put("diagnosis", new JsonStructuralFeature("diagnosis", JsonStructuralFeature.Type.ARRAY));
        encounterFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        encounterFields.put("status", new JsonStructuralFeature("status", JsonStructuralFeature.Type.PRIMITIVE));
        this.resourceFieldsMap.put("Encounter", encounterFields);
        HashMap<String, JsonStructuralFeature> procedureRequestFields = new HashMap<String, JsonStructuralFeature>();
        procedureRequestFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        procedureRequestFields.put("encounter", new JsonStructuralFeature("context", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("ServiceRequest", procedureRequestFields);
    }

    @Override
    public int isFindingsFormat(String rawContent) {
        JsonObject jsonObject = this.getJsonObject(rawContent);
        JsonElement resourceType = jsonObject.get("resourceType");
        return this.checkFindingsFormatProperties(resourceType, jsonObject);
    }

    private int checkFindingsFormatProperties(JsonElement resourceType, JsonObject jsonObject) {
        switch (resourceType.getAsString()) {
            case "Condition": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Condition"), jsonObject);
            }
            case "Encounter": {
                int ret = this.checkFields((Map)this.resourceFieldsMap.get("Encounter"), jsonObject);
                if (!this.checkRequiredField((JsonStructuralFeature)((Map)this.resourceFieldsMap.get("Encounter")).get("status"), jsonObject)) {
                    --ret;
                }
                return ret;
            }
            case "ProcedureRequest": {
                return 0;
            }
            case "ServiceRequest": {
                return this.checkFields((Map)this.resourceFieldsMap.get("ServiceRequest"), jsonObject);
            }
        }
        return 0;
    }

    @Override
    public Optional<String> convertToCurrentFormat(String rawContent) {
        return Optional.empty();
    }
}

