/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.VersionedResource;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ServiceRequestIProcedureRequestTransformer
implements IFhirTransformer<ServiceRequest, IProcedureRequest> {
    private static Logger logger = LoggerFactory.getLogger(ServiceRequestIProcedureRequestTransformer.class);
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IFindingsService findingsService;
    @Reference
    private ICodingService codingService;
    private FindingsContentHelper contentHelper;

    public void activate() {
        this.contentHelper = new FindingsContentHelper();
    }

    @Override
    public Optional<ServiceRequest> getFhirObject(IProcedureRequest localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            return Optional.of((ServiceRequest)resource.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IProcedureRequest> getLocalObject(ServiceRequest fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.findingsService.findById(fhirObject.getId(), IProcedureRequest.class)).isPresent()) {
            return Optional.of((IProcedureRequest)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IProcedureRequest> updateLocalObject(ServiceRequest fhirObject, IProcedureRequest localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<IProcedureRequest> createLocalObject(ServiceRequest fhirObject) {
        String id;
        Optional encounter;
        IProcedureRequest iProcedureRequest = (IProcedureRequest)this.findingsService.create(IProcedureRequest.class);
        this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iProcedureRequest);
        if (fhirObject.getSubject() != null && fhirObject.getSubject().hasReference()) {
            String id2 = fhirObject.getSubject().getReferenceElement().getIdPart();
            Optional patient = this.modelService.load(id2, IPatient.class);
            patient.ifPresent(k -> iProcedureRequest.setPatientId(id2));
        }
        IEncounter iEncounter = null;
        if (fhirObject.getEncounter() != null && fhirObject.getEncounter().hasReference() && (encounter = this.findingsService.findById(id = fhirObject.getEncounter().getReferenceElement().getIdPart(), IEncounter.class)).isPresent()) {
            iEncounter = (IEncounter)encounter.get();
            iProcedureRequest.setEncounter(iEncounter);
        }
        this.findingsService.saveFinding((IFinding)iProcedureRequest);
        if (iEncounter != null) {
            this.writeBehandlungSoapText(iEncounter, fhirObject);
        }
        return Optional.of(iProcedureRequest);
    }

    private void writeBehandlungSoapText(IEncounter iEncounter, ServiceRequest procedureRequest) {
        Optional behandlung = this.modelService.load(iEncounter.getConsultationId(), ch.elexis.core.model.IEncounter.class);
        behandlung.ifPresent(cons -> {
            LockResponse lockresponse = AbstractHelper.acquireLock((Identifiable)cons);
            if (lockresponse.isOk()) {
                String subjectivText = this.getSubjectiveText(iEncounter);
                String assessmentText = this.getAssessmentText(iEncounter);
                String procedureText = this.getProcedureText((ch.elexis.core.model.IEncounter)behandlung.get());
                StringBuilder text = new StringBuilder();
                if (!subjectivText.isEmpty()) {
                    text.append("A:\n" + subjectivText);
                }
                if (!assessmentText.isEmpty()) {
                    if (text.length() > 0) {
                        text.append("\n\n");
                    }
                    text.append("B:\n" + assessmentText);
                }
                if (!procedureText.isEmpty()) {
                    if (text.length() > 0) {
                        text.append("\n\n");
                    }
                    text.append("P:\n" + procedureText);
                }
                logger.debug("Updating SOAP text of cons [" + cons.getId() + "]\n" + text.toString());
                VersionedResource vResource = VersionedResource.load(null);
                vResource.update(text.toString(), "From FHIR");
                cons.setVersionedEntry(vResource);
                this.modelService.save((Identifiable)cons);
                AbstractHelper.releaseLock(lockresponse.getLockInfo());
            }
        });
    }

    private String getProcedureText(ch.elexis.core.model.IEncounter behandlung) {
        StringBuilder ret = new StringBuilder();
        List procedureRequests = this.findingsService.getConsultationsFindings(behandlung.getId(), IProcedureRequest.class);
        if (procedureRequests != null && !procedureRequests.isEmpty()) {
            for (IProcedureRequest iProcedureRequest : procedureRequests) {
                Optional text = iProcedureRequest.getText();
                text.ifPresent(t -> {
                    if (ret.length() > 0) {
                        ret.append("\n");
                    }
                    ret.append((String)t);
                });
            }
        }
        return ret.toString();
    }

    private String getAssessmentText(IEncounter iEncounter) {
        List indication = iEncounter.getIndication();
        StringBuilder ret = new StringBuilder();
        for (ICondition iCondition : indication) {
            boolean hasText;
            List coding = iCondition.getCoding();
            Optional text = iCondition.getText();
            ICondition.ConditionCategory category = iCondition.getCategory();
            if (category != ICondition.ConditionCategory.PROBLEMLISTITEM) continue;
            boolean bl = hasText = text.isPresent() && !((String)text.get()).isEmpty();
            if (ret.length() > 0) {
                ret.append("\n");
            }
            if (hasText) {
                ret.append(text.orElse(""));
            }
            if (coding == null || coding.isEmpty()) continue;
            if (hasText) {
                ret.append(", ");
            }
            for (ICoding iCoding : coding) {
                ret.append(this.codingService.getLabel(iCoding));
            }
        }
        return ret.toString();
    }

    private String getSubjectiveText(IEncounter iEncounter) {
        List observations = this.findingsService.getConsultationsFindings(iEncounter.getConsultationId(), IObservation.class);
        StringBuilder ret = new StringBuilder();
        for (IObservation iObservation : observations) {
            if (iObservation.getCategory() != IObservation.ObservationCategory.SOAP_SUBJECTIVE) continue;
            Optional text = iObservation.getText();
            if (ret.length() > 0) {
                ret.append("\n");
            }
            ret.append(text.orElse(""));
        }
        return ret.toString();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return ServiceRequest.class.equals(fhirClazz) && IProcedureRequest.class.equals(localClazz);
    }
}

