/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.MandantHelper;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.osgi.service.component.annotations.Component;

@Component
public class PractitionerRoleUserTransformer
implements IFhirTransformer<PractitionerRole, IUser> {
    private MandantHelper mandantHelper = new MandantHelper();

    @Override
    public Optional<PractitionerRole> getFhirObject(IUser localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        PractitionerRole practitionerRole = new PractitionerRole();
        practitionerRole.setId((IIdType)new IdDt("PractitionerRole", localObject.getId()));
        List roles = localObject.getRoles();
        for (IRole role : roles) {
            String roleId = role.getId();
            if (roleId == null) continue;
            practitionerRole.addCode(this.mandantHelper.getPractitionerRoleCode(roleId));
        }
        practitionerRole.setActive(localObject.isActive());
        if (localObject.getAssignedContact() != null) {
            practitionerRole.setPractitioner(new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), localObject.getAssignedContact().getId())));
        }
        return Optional.of(practitionerRole);
    }

    @Override
    public Optional<IUser> getLocalObject(PractitionerRole fhirObject) {
        return null;
    }

    @Override
    public Optional<IUser> updateLocalObject(PractitionerRole fhirObject, IUser localObject) {
        return null;
    }

    @Override
    public Optional<IUser> createLocalObject(PractitionerRole fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return PractitionerRole.class.equals(fhirClazz) && IUser.class.equals(localClazz);
    }
}

