/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.services.IModelService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;
import org.osgi.service.component.annotations.Component;

@Component
public class CareTeamUserGroupTransformer
implements IFhirTransformer<CareTeam, IUserGroup> {
    @org.osgi.service.component.annotations.Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    @Override
    public Optional<CareTeam> getFhirObject(IUserGroup localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        CareTeam careTeam = new CareTeam();
        careTeam.setId((IIdType)new IdDt("CareTeam", localObject.getId()));
        careTeam.setName(localObject.getGroupname());
        List users = localObject.getUsers();
        for (IUser iUser : users) {
            if (iUser.getAssignedContact() == null) continue;
            CareTeam.CareTeamParticipantComponent participant = careTeam.addParticipant();
            participant.setMember(new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), iUser.getAssignedContact().getId())));
        }
        return Optional.of(careTeam);
    }

    @Override
    public Optional<IUserGroup> getLocalObject(CareTeam fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.coreModelService.load(id, IUserGroup.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IUserGroup> updateLocalObject(CareTeam fhirObject, IUserGroup localObject) {
        return null;
    }

    @Override
    public Optional<IUserGroup> createLocalObject(CareTeam fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return CareTeam.class.equals(fhirClazz) && IUserGroup.class.equals(localClazz);
    }
}

