/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.AbstractFindingsAccessor;
import ch.elexis.core.findings.util.fhir.accessor.EnumMapping;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.LoggerFactory;

public class AllergyIntoleranceAccessor
extends AbstractFindingsAccessor {
    private EnumMapping categoryMapping = new EnumMapping((Class<? extends Enum<?>>)AllergyIntolerance.AllergyIntoleranceCategory.class, (Enum<?>)AllergyIntolerance.AllergyIntoleranceCategory.NULL, (Class<? extends Enum<?>>)IAllergyIntolerance.AllergyIntoleranceCategory.class, (Enum<?>)IAllergyIntolerance.AllergyIntoleranceCategory.UNKNOWN);

    public void setPatientId(DomainResource resource, String patientId) {
        AllergyIntolerance fhAllergyIntolerance = (AllergyIntolerance)resource;
        fhAllergyIntolerance.setPatient(new Reference((IIdType)new IdDt("Patient", patientId)));
    }

    public Optional<LocalDate> getDateRecorded(DomainResource resource) {
        AllergyIntolerance fhirCondition = (AllergyIntolerance)resource;
        Date date = fhirCondition.getRecordedDate();
        if (date != null) {
            return Optional.of(this.getLocalDate(date));
        }
        return Optional.empty();
    }

    public IAllergyIntolerance.AllergyIntoleranceCategory getCategory(DomainResource domainResource) {
        List categories;
        AllergyIntolerance fhirCondition = (AllergyIntolerance)domainResource;
        if (!fhirCondition.getCategory().isEmpty() && !(categories = fhirCondition.getCategory()).isEmpty()) {
            for (Enumeration categoryEnum : categories) {
                try {
                    Enum<?> localValue = this.categoryMapping.getLocalEnumValueByEnum((Enum)categoryEnum.getValue());
                    if (localValue == null) continue;
                    return (IAllergyIntolerance.AllergyIntoleranceCategory)localValue;
                }
                catch (IllegalArgumentException e) {
                    LoggerFactory.getLogger(AllergyIntoleranceAccessor.class).warn(e.getMessage());
                }
            }
        }
        return IAllergyIntolerance.AllergyIntoleranceCategory.UNKNOWN;
    }

    public void setCategory(DomainResource resource, IAllergyIntolerance.AllergyIntoleranceCategory category) {
        AllergyIntolerance fhirCondition = (AllergyIntolerance)resource;
        if (category == IAllergyIntolerance.AllergyIntoleranceCategory.UNKNOWN) {
            if (fhirCondition.hasCategory()) {
                fhirCondition.setCategory(null);
            }
            return;
        }
        AllergyIntolerance.AllergyIntoleranceCategory fhirCategoryCode = (AllergyIntolerance.AllergyIntoleranceCategory)this.categoryMapping.getFhirEnumValueByEnum((Enum<?>)category);
        if (fhirCategoryCode != null) {
            if (fhirCondition.hasCategory()) {
                fhirCondition.setCategory(null);
            }
            fhirCondition.addCategory(fhirCategoryCode);
        }
    }

    public List<ICoding> getCoding(DomainResource resource) {
        AllergyIntolerance fhirCondition = (AllergyIntolerance)resource;
        CodeableConcept codeableConcept = fhirCondition.getCode();
        if (codeableConcept != null) {
            return ModelUtil.getCodingsFromConcept(codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setCoding(DomainResource resource, List<ICoding> coding) {
        AllergyIntolerance fhirCondition = (AllergyIntolerance)resource;
        CodeableConcept codeableConcept = fhirCondition.getCode();
        if (codeableConcept == null) {
            codeableConcept = new CodeableConcept();
        }
        ModelUtil.setCodingsToConcept(codeableConcept, coding);
        fhirCondition.setCode(codeableConcept);
    }
}

