/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.util.fhir.ElexisFhirTypeMap;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerRegistry;
import ch.elexis.core.model.Identifiable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceInfo {
    private String resourceId;
    private Class<? extends Identifiable> localClass;
    private Class<? extends IBaseResource> fhirClass;

    private ResourceInfo() {
    }

    public static ResourceInfo of(String fhirResourceId) {
        String[] split = fhirResourceId.split("/");
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.fhirClass = ElexisFhirTypeMap.mapFromString(split[0]);
        resourceInfo.localClass = ElexisFhirTypeMap.mapFromFhir(resourceInfo.fhirClass);
        resourceInfo.resourceId = split[1];
        return resourceInfo;
    }

    public static ResourceInfo of(Identifiable localObject) {
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.localClass = localObject.getClass();
        resourceInfo.fhirClass = ElexisFhirTypeMap.mapFromLocal(localObject.getClass());
        resourceInfo.resourceId = localObject.getId();
        return resourceInfo;
    }

    public IFhirTransformer<?, ?> getTransformer(IFhirTransformerRegistry transformerRegistry) {
        return transformerRegistry.getTransformerFor(this.fhirClass, this.localClass);
    }

    public Class<? extends Identifiable> getLocalClass() {
        return this.localClass;
    }

    public Class<? extends IBaseResource> getFhirClass() {
        return this.fhirClass;
    }

    public String getId() {
        return this.resourceId;
    }

    public IIdType getIId() {
        return new IdDt(this.fhirClass.getSimpleName(), this.resourceId);
    }
}

