/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Reference;

public class ICoverageHelper
extends AbstractHelper {
    public String getDependent(ICoverage coverage) {
        BillingLaw law = coverage.getBillingSystem().getLaw();
        if (BillingLaw.UVG == law) {
            return (String)coverage.getExtInfo((Object)"Unfallnummer");
        }
        if (BillingLaw.IV == law) {
            return (String)coverage.getExtInfo((Object)"Fallnummer");
        }
        return null;
    }

    public void setDependent(ICoverage coverage, String bin) {
        String billingSystem = coverage.getBillingSystem().getName();
        if (billingSystem != null && !billingSystem.isEmpty()) {
            if (billingSystem.equals("UVG")) {
                coverage.setExtInfo((Object)"Unfallnummer", (Object)bin);
            } else {
                coverage.setExtInfo((Object)"Fallnummer", (Object)bin);
            }
        }
    }

    public Reference getBeneficiaryReference(ICoverage fall) {
        IPatient patient = fall.getPatient();
        if (patient != null) {
            return new Reference((IIdType)new IdDt("Patient", patient.getId()));
        }
        return null;
    }

    public Reference getPolicyHolderReference(ICoverage coverage) {
        IContact costBearer = coverage.getGuarantor();
        if (costBearer != null) {
            String contactType = costBearer.isOrganization() ? "Organization" : "Patient";
            return new Reference((IIdType)new IdDt(contactType, costBearer.getId()));
        }
        return null;
    }

    public Optional<IContact> getPolicyHolderByReference(IModelService coreModelService, Reference source) {
        String id;
        Optional<String> localId;
        if (source != null && (localId = FhirUtil.getLocalId(id = source.getId() != null ? source.getId() : source.getReference())).isPresent()) {
            return coreModelService.load(localId.get(), IContact.class);
        }
        return Optional.empty();
    }

    public Reference getPayor(ICoverage fall) {
        IContact kostenTr = fall.getCostBearer();
        if (kostenTr != null) {
            String contactType = kostenTr.isOrganization() ? "Organization" : "Patient";
            return new Reference((IIdType)new IdDt(contactType, kostenTr.getId()));
        }
        return null;
    }

    public Optional<IContact> getPayorByReference(IModelService coreModelService, Reference payorFirstRep) {
        Optional<String> localId;
        if (payorFirstRep != null && (localId = FhirUtil.getLocalId(payorFirstRep.getId())).isPresent()) {
            return coreModelService.load(localId.get(), IContact.class);
        }
        return Optional.empty();
    }

    public Period getPeriod(ICoverage coverage) {
        LocalDate endDate;
        Period period = new Period();
        LocalDate startDate = coverage.getDateFrom();
        if (startDate != null) {
            period.setStart(this.getDate(startDate.atStartOfDay()));
        }
        if ((endDate = coverage.getDateTo()) != null) {
            period.setEnd(this.getDate(endDate.atStartOfDay()));
        }
        return period;
    }

    public void setPeriod(ICoverage coverage, Period period) {
        if (period.getStart() != null) {
            coverage.setDateFrom(this.getLocalDateTime(period.getStart()).toLocalDate());
        }
        if (period.getEnd() != null) {
            coverage.setDateTo(this.getLocalDateTime(period.getEnd()).toLocalDate());
        } else {
            coverage.setDateTo(null);
        }
    }

    public String getFallText(ICoverage coverage) {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String grund = coverage.getReason();
        String bezeichnung = coverage.getDescription();
        LocalDate dateFrom = coverage.getDateFrom();
        LocalDate dateTo = coverage.getDateTo();
        String billingSystem = coverage.getBillingSystem().getName();
        if (dateFrom == null) {
            dateFrom = LocalDate.of(1970, 1, 1);
        }
        StringBuilder ret = new StringBuilder();
        if (dateTo != null) {
            ret.append("-GESCHLOSSEN-");
        }
        ret.append(billingSystem).append(": ").append(grund).append(" - ");
        ret.append(bezeichnung).append("(");
        String ed = dateTo == null ? "offen" : dateTo.format(dateFormat);
        ret.append(dateFrom.format(dateFormat)).append("-").append(ed).append(")");
        return ret.toString();
    }

    public Optional<Coding> getType(ICoverage coverage) {
        String billingSystem = coverage.getBillingSystem().getName();
        if (billingSystem != null) {
            Coding coding = new Coding();
            coding.setSystem(CodingSystem.ELEXIS_COVERAGE_TYPE.getSystem());
            coding.setCode(billingSystem);
            return Optional.of(coding);
        }
        return Optional.empty();
    }

    public Optional<String> getType(Coverage fhirObject) {
        CodeableConcept fhirType = fhirObject.getType();
        for (Coding coding : fhirType.getCoding()) {
            if (!coding.getSystem().equals(CodingSystem.ELEXIS_COVERAGE_TYPE.getSystem())) continue;
            return Optional.ofNullable(coding.getCode());
        }
        return Optional.empty();
    }

    public Optional<Coding> getReason(ICoverage coverage) {
        String reason = coverage.getReason();
        if (reason != null) {
            Coding coding = new Coding();
            coding.setSystem(CodingSystem.ELEXIS_COVERAGE_REASON.getSystem());
            coding.setCode(reason);
            return Optional.of(coding);
        }
        return Optional.empty();
    }

    public Optional<Identifier> getInsuranceNumber(ICoverage coverage) {
        String insuranceNumber = coverage.getInsuranceNumber();
        if (insuranceNumber != null) {
            Identifier identifier = new Identifier();
            identifier.setSystem("urn:oid:2.16.756.5.30.1.123.100.1.1.1");
            identifier.setValue(insuranceNumber);
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    public Optional<Coding> getAccidentDate(ICoverage localObject) {
        String accidentDate;
        if (Objects.equals(BillingLaw.UVG, localObject.getBillingSystem().getLaw()) && (accidentDate = (String)localObject.getExtInfo((Object)"Unfalldatum")) != null) {
            TimeTool timeTool = new TimeTool(accidentDate);
            Coding coding = new Coding();
            coding.setSystem(CodingSystem.ELEXIS_COVERAGE_UVG_ACCIDENTDATE.getSystem());
            coding.setCode(timeTool.toString(14));
            return Optional.of(coding);
        }
        return Optional.empty();
    }

    public void setInsuranceNumber(Coverage source, ICoverage target) {
        Optional<Identifier> insuranceNumberIdentifier = source.getIdentifier().stream().filter(id -> "urn:oid:2.16.756.5.30.1.123.100.1.1.1".equals(id.getSystem())).findFirst();
        if (insuranceNumberIdentifier.isPresent()) {
            target.setInsuranceNumber(insuranceNumberIdentifier.get().getValue());
            target.setExtInfo((Object)FallConstants.FLD_EXT_VERSICHERUNGSNUMMER, (Object)insuranceNumberIdentifier.get().getValue());
        }
    }
}

