/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views.nattable;

import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.views.nattable.DynamicDataProvider;
import java.util.List;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class FindingsNatTableTooltip
extends DefaultToolTip {
    private NatTable natTable;
    private DynamicDataProvider dataProvider;

    public FindingsNatTableTooltip(NatTable natTable, DynamicDataProvider dataProvider) {
        super((Control)natTable, 2, false);
        this.natTable = natTable;
        this.dataProvider = dataProvider;
    }

    protected Object getToolTipArea(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        return new Point(col, row);
    }

    protected String getText(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        Object value = this.dataProvider.getDataValue(this.natTable.getColumnIndexByPosition(col), this.natTable.getRowIndexByPosition(row));
        if (value instanceof List) {
            List findings = (List)value;
            StringBuilder sb = new StringBuilder();
            for (IFinding iFinding : findings) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(iFinding.getText().orElse(""));
            }
            return sb.toString();
        }
        return null;
    }

    protected boolean shouldCreateToolTip(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        Object value = this.dataProvider.getDataValue(this.natTable.getColumnIndexByPosition(col), this.natTable.getRowIndexByPosition(row));
        return value instanceof List;
    }
}

