/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.ui.UiDesk;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodesSelectionComposite
extends Composite
implements ISelectionProvider {
    private List<CodeSelectionAction> currentSelection = new ArrayList<CodeSelectionAction>();
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private ToolBarManager manager;
    private List<ICoding> visibleCodings;

    public CodesSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setBackground(UiDesk.getColor((String)"weiss"));
        this.setLayout((Layout)new FillLayout());
        this.manager = new ToolBarManager(64);
        this.manager.createControl((Composite)this);
        this.refresh();
    }

    public void refresh() {
        this.updateVisibleCodings();
        this.updateSelectedCodings();
    }

    private void updateVisibleCodings() {
        this.visibleCodings = FindingsUiUtil.loadVisibleCodings();
        if (this.visibleCodings.isEmpty()) {
            this.visibleCodings = FindingsUiUtil.getAvailableCodings();
        }
        this.visibleCodings.sort(new Comparator<ICoding>(){

            @Override
            public int compare(ICoding arg0, ICoding arg1) {
                if (arg0 instanceof ILocalCoding && arg1 instanceof ILocalCoding) {
                    ILocalCoding left = (ILocalCoding)arg0;
                    ILocalCoding right = (ILocalCoding)arg1;
                    return Integer.valueOf(left.getPrio()).compareTo(right.getPrio());
                }
                return 0;
            }
        });
        this.manager.removeAll();
        for (ICoding iCoding : this.visibleCodings) {
            this.manager.add((IAction)new CodeSelectionAction(iCoding));
        }
        this.manager.add((IAction)new AllSelectionAction());
        this.manager.update(true);
        this.getParent().layout(true);
    }

    private void updateSelectedCodings() {
        this.currentSelection.clear();
        List<ICoding> selectedCodings = FindingsUiUtil.loadSelectedCodings();
        if (selectedCodings != null) {
            IContributionItem[] items = this.manager.getItems();
            for (ICoding iCoding : selectedCodings) {
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    CodeSelectionAction csAction;
                    IAction action;
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    if (iContributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)iContributionItem).getAction()) instanceof CodeSelectionAction && (csAction = (CodeSelectionAction)action).getiCoding().getCode().equals(iCoding.getCode())) {
                        csAction.setChecked(true);
                        this.currentSelection.add(csAction);
                    }
                    ++n2;
                }
            }
            this.fireSelectionChanged();
            this.manager.update(true);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.currentSelection.stream().map(action -> action.getiCoding()).collect(Collectors.toList()));
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            listener.selectionChanged(event);
        }
    }

    public void selectAllFilters() {
        int currentSelectionSize = this.currentSelection.size();
        this.currentSelection.clear();
        IContributionItem[] items = this.manager.getItems();
        if (currentSelectionSize == items.length - 1) {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem iContributionItem = iContributionItemArray[n2];
                if (iContributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)iContributionItem).getAction()) instanceof CodeSelectionAction) {
                    CodeSelectionAction csAction = (CodeSelectionAction)action;
                    csAction.setChecked(false);
                }
                ++n2;
            }
        } else {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                IAction action;
                IContributionItem iContributionItem = iContributionItemArray[n3];
                if (iContributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)iContributionItem).getAction()) instanceof CodeSelectionAction) {
                    CodeSelectionAction csAction = (CodeSelectionAction)action;
                    csAction.setChecked(true);
                    this.currentSelection.add(csAction);
                }
                ++n3;
            }
        }
        this.fireSelectionChanged();
        this.manager.update(true);
        FindingsUiUtil.saveSelectedCodings(this.currentSelection.stream().map(a -> a.getiCoding()).collect(Collectors.toList()));
    }

    public boolean isAnyFilterDeselected() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.manager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof CodeSelectionAction && !action.isChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class AllSelectionAction
    extends Action {
        public AllSelectionAction() {
            super("Alle", 1);
        }

        public void run() {
            int currentSelectionSize = CodesSelectionComposite.this.currentSelection.size();
            CodesSelectionComposite.this.currentSelection.clear();
            IContributionItem[] items = CodesSelectionComposite.this.manager.getItems();
            if (currentSelectionSize == items.length - 1) {
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction action;
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    if (iContributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)iContributionItem).getAction()) instanceof CodeSelectionAction) {
                        CodeSelectionAction csAction = (CodeSelectionAction)action;
                        csAction.setChecked(false);
                    }
                    ++n2;
                }
            } else {
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n3 = 0;
                while (n3 < n) {
                    IAction action;
                    IContributionItem iContributionItem = iContributionItemArray[n3];
                    if (iContributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)iContributionItem).getAction()) instanceof CodeSelectionAction) {
                        CodeSelectionAction csAction = (CodeSelectionAction)action;
                        csAction.setChecked(true);
                        CodesSelectionComposite.this.currentSelection.add(csAction);
                    }
                    ++n3;
                }
            }
            CodesSelectionComposite.this.fireSelectionChanged();
            CodesSelectionComposite.this.manager.update(true);
            FindingsUiUtil.saveSelectedCodings(CodesSelectionComposite.this.currentSelection.stream().map(a -> a.getiCoding()).collect(Collectors.toList()));
        }
    }

    private class CodeSelectionAction
    extends Action {
        private ICoding iCoding;

        public CodeSelectionAction(ICoding iCoding) {
            super(iCoding.getDisplay(), 2);
            this.iCoding = iCoding;
        }

        public ICoding getiCoding() {
            return this.iCoding;
        }

        public void run() {
            if (CodesSelectionComposite.this.currentSelection.contains((Object)this)) {
                CodesSelectionComposite.this.currentSelection.remove((Object)this);
            } else {
                CodesSelectionComposite.this.currentSelection.add(this);
            }
            CodesSelectionComposite.this.fireSelectionChanged();
            CodesSelectionComposite.this.manager.update(true);
            FindingsUiUtil.saveSelectedCodings(CodesSelectionComposite.this.currentSelection.stream().map(a -> a.getiCoding()).collect(Collectors.toList()));
        }
    }
}

