/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.cons;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.ui.action.AddFindingAction;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.services.FindingsTemplateServiceComponent;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class KonsExtension
implements IKonsExtension {
    IRichTextDisplay mine;
    public static final String EXTENSION_ID = "ch.elexis.core.findings.ui.cons";
    private static final String FINDINGS_TITLE = "Befund: ";

    public String connect(IRichTextDisplay tf) {
        this.mine = tf;
        this.mine.addDropReceiver(IObservation.class, (IKonsExtension)this);
        return EXTENSION_ID;
    }

    public IRichTextDisplay getRichTextDisplay() {
        return this.mine;
    }

    public boolean doLayout(StyleRange styleRange, String provider, String id) {
        Color color;
        Optional template;
        Optional localCode;
        styleRange.background = UiDesk.getColor((String)"hellgrau");
        Optional observation = FindingsServiceComponent.getService().findById(id, IObservation.class);
        if (observation.isPresent() && (localCode = ModelUtil.getCodeBySystem((List)((IObservation)observation.get()).getCoding(), (CodingSystem)CodingSystem.ELEXIS_LOCAL_CODESYSTEM)).isPresent() && (template = FindingsTemplateServiceComponent.getService().getFindingsTemplate((ICoding)localCode.get())).isPresent() && StringUtils.isNotBlank((CharSequence)((FindingsTemplate)template.get()).getColor()) && (color = CoreUiUtil.getColorForString((String)((FindingsTemplate)template.get()).getColor())) != null) {
            styleRange.background = color;
        }
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        Optional observation = FindingsServiceComponent.getService().findById(refID, IObservation.class);
        observation.ifPresent(obs -> FindingsUiUtil.executeCommand("ch.elexis.core.findings.ui.commandEdit", (IFinding)obs));
        return true;
    }

    public String updateXRef(String provider, String id) {
        Optional observation = FindingsServiceComponent.getService().findById(id, IObservation.class);
        if (observation.isPresent()) {
            return this.getXRefText((IFinding)observation.get());
        }
        return null;
    }

    public void updateXRef(Samdas.XRef xref) {
        if (this.mine instanceof EnhancedTextField) {
            ((EnhancedTextField)this.mine).updateXRef(xref);
        }
    }

    public void insert(Object o, int pos) {
        if (o instanceof IObservation) {
            IObservation observation = (IObservation)o;
            Optional encounterOpt = ContextServiceHolder.get().getTyped(IEncounter.class);
            encounterOpt.ifPresent(encounter -> {
                this.mine.insertXRef(pos, this.getXRefText((IFinding)observation), EXTENSION_ID, observation.getId());
                Samdas samdas = new Samdas(this.mine.getContentsAsXML());
                EncounterServiceHolder.get().updateVersionedEntry(encounter, samdas);
                CoreModelServiceHolder.get().save((Identifiable)encounter);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", encounter);
            });
        }
    }

    public String getXRefText(IFinding finding) {
        return FINDINGS_TITLE + finding.getText().orElse("?");
    }

    public IAction[] getActions() {
        IAction[] ret = new IAction[]{new AddFindingAction(this)};
        return ret;
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

